package ru.yandex.msearch.proxy.ora.wmi.json;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.msearch.proxy.ora.wmi.fields.WmiField;

import ru.yandex.search.json.HandlersManager;
import ru.yandex.search.json.KeyCollectingHandler;

public class EmailHandler extends KeyCollectingHandler {
    private final Map<String, String> map = new HashMap<>();
    private final List<String> wrapper;

    public EmailHandler(
        final HandlersManager manager,
        final List<String> wrapper)
    {
        super(manager);
        this.wrapper = wrapper;
    }

    @Override
    public void key(final String key) {
        manager.push(new PrimitiveMapHandler(manager, key, map));
    }

    @Override
    public void endObject() {
        String local = map.get(WmiField.EMAIL_LOCAL);
        String domain = map.get(WmiField.EMAIL_DOMAIN);
        String display = map.get(WmiField.EMAIL_DISPLAY);
        String email = WmiField.constructEmail(domain, local, display);
        wrapper.add(email);
        manager.pop();
    }
}

