package ru.yandex.msearch.proxy.ora.wmi.json;

import ru.yandex.json.parser.ContentHandler;

import ru.yandex.msearch.proxy.collector.Collector;
import ru.yandex.msearch.proxy.document.Document;
import ru.yandex.msearch.proxy.ora.wmi.fields.WmiField;

import ru.yandex.search.json.KeyCollectingHandler;
import ru.yandex.search.json.SkipObjectEntryHandler;

public class EnvelopeHandler extends KeyCollectingHandler {
    private final WmiJsonHandlersManager manager;
    private final Collector collector;
    private final Document doc;

    public EnvelopeHandler(
        final WmiJsonHandlersManager manager,
        final Collector collector)
    {
        super(manager);
        this.manager = manager;
        this.collector = collector;
        doc = collector.createDocument();
    }

    @Override
    public void key(final String key) {
        ContentHandler handler;
        switch (key) {
            case WmiField.FROM:
            case WmiField.TO:
            case WmiField.CC:
            case WmiField.BCC:
            case WmiField.REPLY_TO:
                handler = new EmailsHandler(manager, key, doc);
                break;

            case WmiField.LABELS:
            case WmiField.TYPES:
                handler = new JoinArrayHandler(manager, key, doc, '\n');
                break;

            case WmiField.SPECIAL_LABELS:
            case WmiField.ATTACHMENTS:
                handler = new SkipObjectEntryHandler(manager);
                break;

            default:
                handler = new PrimitiveDocHandler(manager, key, doc);
                break;
        }
        manager.push(handler);
    }

    @Override
    public void endObject() {
        String mid = doc.getAttr("mid");
        if (mid != null) {
            Document toCollect = manager.documents().get(mid);
            if (toCollect != null) {
                toCollect.setAttrs(doc);
                collector.collect(toCollect);
                manager.incFound();
            }
        }
        manager.pop();
    }
}

