package ru.yandex.msearch.proxy.ora.wmi.json;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.json.parser.BadContentHandler;

import ru.yandex.msearch.proxy.document.Document;

import ru.yandex.search.json.HandlersManager;

public class JoinArrayHandler extends BadContentHandler {
    private final List<String> toJoin = new ArrayList<>();
    private final HandlersManager manager;
    private final String key;
    private final Document doc;
    private final char delimiter;

    public JoinArrayHandler(
        final HandlersManager manager,
        final String key,
        final Document doc,
        final char delimiter)
    {
        this.manager = manager;
        this.key = key;
        this.doc = doc;
        this.delimiter = delimiter;
    }

    @Override
    public void startArray() {
        manager.push(new PrimitiveArrayHandler(manager, toJoin));
    }

    @Override
    public void endObjectEntry() {
        String value = StringUtils.join(toJoin, delimiter);
        doc.setAttr(key, value);
        manager.pop();
    }
}

