package ru.yandex.msearch.proxy.ora.wmi.json;

import java.util.List;

import ru.yandex.json.parser.BadContentHandler;

import ru.yandex.search.json.HandlersManager;

public class PrimitiveArrayHandler extends BadContentHandler {
    private final HandlersManager manager;
    private final List<String> list;

    public PrimitiveArrayHandler(
        final HandlersManager manager,
        final List<String> list)
    {
        this.manager = manager;
        this.list = list;
    }

    // CSOFF: ParameterNumber
    @Override
    public void value(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
    {
        if (eol) {
            list.add(manager.sc().appendLast(buf, off, len));
        } else {
            manager.sc().append(buf, off, len);
        }
    }
    // CSON: ParameterNumber

    @Override
    public void value(final long value) {
        list.add(Long.toString(value));
    }

    @Override
    public void value(final double value) {
        list.add(Double.toString(value));
    }

    @Override
    public void value(final boolean value) {
        list.add(Boolean.toString(value));
    }

    @Override
    public void endArray() {
        manager.pop();
    }
}

