package ru.yandex.msearch.proxy.ora.wmi.json;

import ru.yandex.json.parser.JsonException;

import ru.yandex.msearch.proxy.document.Document;

import ru.yandex.search.json.HandlersManager;
import ru.yandex.search.json.SkipObjectEntryHandler;

public class PrimitiveDocHandler extends SkipObjectEntryHandler {
    private final String key;
    private final Document doc;

    public PrimitiveDocHandler(
        final HandlersManager manager,
        final String key,
        final Document doc)
    {
        super(manager);
        this.key = key;
        this.doc = doc;
    }

    // CSOFF: ParameterNumber
    @Override
    public void value(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
    {
        if (eol) {
            doc.setAttr(key, manager.sc().appendLast(buf, off, len));
        } else {
            manager.sc().append(buf, off, len);
        }
    }
    // CSON: ParameterNumber

    @Override
    public void value(final long value) {
        doc.setAttr(key, Long.toString(value));
    }

    @Override
    public void value(final double value) {
        doc.setAttr(key, Double.toString(value));
    }

    @Override
    public void value(final boolean value) {
        doc.setAttr(key, Boolean.toString(value));
    }
}

