package ru.yandex.msearch.proxy.ora.wmi.json;

import java.util.Map;

import ru.yandex.json.parser.JsonException;

import ru.yandex.search.json.DefaultHandler;
import ru.yandex.search.json.HandlersManager;

public class PrimitiveMapHandler extends DefaultHandler {
    private final String key;
    private final Map<String, String> map;

    public PrimitiveMapHandler(
        final HandlersManager manager,
        final String key,
        final Map<String, String> map)
    {
        super(manager);
        this.key = key;
        this.map = map;
    }

    @Override
    public void value(final String value) {
        map.put(key, value);
    }

    @Override
    public void value(final long value) {
        map.put(key, Long.toString(value));
    }

    @Override
    public void value(final double value) {
        map.put(key, Double.toString(value));
    }

    @Override
    public void value(final boolean value) {
        map.put(key, Boolean.toString(value));
    }
}

