package ru.yandex.msearch.proxy.parallel;

import java.io.IOException;

import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import ru.yandex.msearch.proxy.MsearchProxyException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ParallelExec
{
    private Vector<ParallelWorker> threads = new Vector<ParallelWorker>();
    private Vector<ParallelWorker> threadsInWork = new Vector<ParallelWorker>();
    int threadsNr;
    private boolean abort = false;

    private static ThreadPoolExecutor executor = null;// = new ThreadPoolExecutor( C;
    private static Object initLock = new Object();

    public static void init(final IniConfig config) throws ConfigException {
        int threads = config.getInt("threads", 30);
        int threadsMax = config.getInt("threads_max", 150);
	executor = new ThreadPoolExecutor(
	    threads,
	    threadsMax,
	    10,
	    TimeUnit.SECONDS,
	    new LinkedBlockingQueue<Runnable>()
	);
    }

    public ParallelExec( int threadsNr ) throws MsearchProxyException
    {
	this.threadsNr = threadsNr;
	for( int i = 0; i < threadsNr; i++ )
	{
	    ParallelWorker w;
	    w = new ParallelWorker( this );
	    threads.add( w );
//	    (new Thread(w, "ParallelExecWorker")).start();
	    executor.execute( w );
	}
    }
    

    public void addWork( ParaWork work, Object workObj ) throws MsearchProxyException
    {
	if( abort ) return;
	ParallelWorker w = null;

	while( w == null )
	{
	    synchronized( threads )
	    {
		if( abort ) return;
		if( threads.size() == 0 )
		{
		    try
		    {
			threads.wait(1000);
        	    } catch (InterruptedException e) {
			continue;
		    }
		}
		else
		{
		    w = threads.get(0);
		    threads.remove(0);
		    threadsInWork.add(w);
		}
	    }
	}
	if( abort ) freeWorker( w );
	else w.setWork( work, workObj );
    }

    public void freeWorker( ParallelWorker w )
    {
    	synchronized( threads )
	{
	    threads.add( w );
	    threadsInWork.remove( w );
	    threads.notify();
	}
    }

    public void stop()
    {
	int freeThreads = 0;
//	System.err.println( "ParallelExec: waiting for threads to finish work" );
	while( freeThreads < threadsNr )
	{
	    synchronized( threads )
	    {
		freeThreads = threads.size();
//		System.err.println( "ParallelExec: waiting for threads to finish work: " + freeThreads );
		if( freeThreads < threadsNr )
		{
		    try
		    {
			threads.wait(1000);
        	    } catch (InterruptedException e)                                                                                                                                                         
		    {
			continue;
		    }
		}
	    }
	}
//	System.err.println( "ParallelExec: all threads have finished their works" );
	synchronized( threads )
	{
	    for( int i = 0; i < threadsNr; i++ )
	    {
		ParallelWorker w;
		w = threads.get(i);
		w.stop();
	    }
	}
//	System.err.println( "ParallelExec: stoped all threads" );
    }
    
    public void abort()
    {
	synchronized( threads )
	{
	    abort = true;
	    for( int i = 0; i < threadsInWork.size(); i++ )
	    {
		threadsInWork.get(i).abort();
	    }
	    for( int i = 0; i < threads.size(); i++ )
	    {
		threads.get(i).abort();
	    }
	    threads.notify();
	}
	stop();
    }
}

