package ru.yandex.msearch.proxy.parallel;

class ParallelWorker implements Runnable
{
    ParallelExec parent;
//    Document doc;

    private Object lock = new Object();
    private Object workObj = null;
    private ParaWork work;
    volatile boolean exit = false;

    public ParallelWorker( ParallelExec parent )
    {
	this.parent = parent;
	workObj = null;
	work = null;
    }
    
    public void run()
    {
	while( !exit )
	{
	    synchronized( lock )
	    {
		if( work == null )
		{
	    	    try
	    	    {
			lock.wait();
        	    } catch (InterruptedException e)                                                                                                                                                         
		    {                                                                                                                                                                                        
			e.printStackTrace();                                                                                                                                                                 
	    		continue;                                                                                                                                                                            
		    }
		    if( exit ) break;                                                                                                                                                                                        	
		}
	    }
	    
	    if( work != null )
	    {
		Thread.currentThread().setName( "ParallelWorker<" + work.cmd + ">" );
		try
		{
		    work.exec();
//		    index.doAddDocument( doc, prefix, shardNo );
		} catch( Exception e )
		{
		    e.printStackTrace();
		}
	        workObj = null;
	        work = null;
		parent.freeWorker( this );
//		System.err.println( "FREE WORKER" );
	    }
	}
        Thread.currentThread().setName( "ParallelWorker_polled" );
    }
    
    public void setWork( ParaWork work, Object workObj )
    {
//	System.err.println( "SET WORK" );
	this.work = work;
	this.workObj = workObj;
	synchronized( lock )
	{
	    lock.notify();
	}
    }
    
    public void stop()
    {
	synchronized( lock )
	{
	    exit = true;
	    lock.notify();
	}
    }
    
    public void abort()
    {
	synchronized( lock )
	{
	    if( work != null && work.cmd.equals("general") )
	    {
		work.abort();
		exit = true;
	    }
	}
    }
}

