package ru.yandex.msearch.proxy.search;

import java.util.LinkedList;
import java.util.List;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.HashMap;
import java.util.Stack;
import java.io.Reader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.InputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.URLConnection;
import java.net.HttpURLConnection;

import org.apache.xerces.impl.io.UTF8Reader;


//import org.json.*;
import org.json.simple.JSONObject;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.ParseException;

import ru.yandex.msearch.proxy.document.Document;
import ru.yandex.msearch.proxy.collector.Collector;
import ru.yandex.msearch.proxy.HttpServer;

public class LuceneJSONTransformer implements ContentHandler
{
private boolean hitsCount = false;
private Collector collector;
private int relevance = 0;
private boolean end = false;
private HttpServer.RequestContext ctx;
private ContentHandler currentHandler;
private ContentHandler rootHandler;
private ContentHandler hitsArrayHandler;
private DocumentHandler documentHandler;
private DocumentHandler subDocumentHandler;
private MergedDocsHandler mergedDocsHandler;
private JSONParser parent;

    public LuceneJSONTransformer( JSONParser parent, HttpServer.RequestContext ctx, Collector collector )
    {
        this.collector = collector;
        this.ctx = ctx;
        this.parent = parent;
        
        currentHandler = rootHandler = new RootHandler();
        hitsArrayHandler = new HitsArrayHandler();
        documentHandler = new DocumentHandler( false );
        subDocumentHandler = new DocumentHandler( true );
        mergedDocsHandler = new MergedDocsHandler();
    }

    public boolean endArray() throws ParseException, IOException
    {
	return currentHandler.endArray();
    }

    public void endJSON() throws ParseException, IOException
    {
        end = true;
    }

    public final boolean end()
    {
        return this.end;
    }

    public boolean endObject() throws ParseException, IOException
    {
	return currentHandler.endObject();
    }

    public boolean endObjectEntry() throws ParseException, IOException
    {
	return currentHandler.endObjectEntry();
    }

    public boolean primitive(Object value) throws ParseException, IOException
    {
	return currentHandler.primitive( value );
    }

    public boolean startArray() throws ParseException, IOException
    {
	return currentHandler.startArray();
    }

    public void startJSON() throws ParseException, IOException
    {
//	return currentHandler.startJSON();
    }

    public boolean startObject() throws ParseException, IOException
    {
	return currentHandler.startObject();
    }

    public boolean startObjectEntry(String key) throws ParseException, IOException
    {
	return currentHandler.startObjectEntry( key );
    }

    public void setHandler( ContentHandler h )
    {
	currentHandler = h;
    }

    private class RootHandler extends FailingHandler
    {
	@Override
        public void endJSON () throws ParseException, IOException
    	{
    	    end = true;
    	}

	@Override
	public boolean startObject() throws ParseException, IOException
	{
	    return true;
	}

	@Override
	public boolean endObject() throws ParseException, IOException
	{
	    return true;
	}
	
	@Override
    	public boolean endObjectEntry () throws ParseException, IOException
    	{
    	    return true;
    	}

	@Override
    	public boolean primitive (Object value) throws ParseException, IOException
    	{
    	    if( hitsCount )
    	    {
    	        collector.incTotalCount( ((Number)value).intValue() );
    	    }
    	    return true;
    	}

	@Override
    	public boolean startObjectEntry (String key) throws ParseException, IOException
    	{
    	    if( key.equalsIgnoreCase("hitsCount") )
    	    {
    	        hitsCount = true;
    	    }
    	    else if( key.equalsIgnoreCase("hitsArray") )
    	    {
    	        setHandler( hitsArrayHandler );
    	    }
    	    else
    	    {
//    	        throw new ParseException( "Unknown json object field: " + key );
    		throw new ParseException( ParseException.ERROR_UNEXPECTED_TOKEN );
    	    }
    	    return true;
    	}
    }

    private class HitsArrayHandler extends FailingHandler
    {
	@Override
    	public boolean startArray () throws ParseException, IOException
    	{
    	    return true;
    	}
    
	@Override
	public boolean endObject () throws ParseException, IOException
	{
//	    collector.collect( 
	    return true;
	}
    	
	@Override
	public boolean endArray () throws ParseException, IOException
    	{
    	    setHandler( rootHandler );
    	    return true;
    	}

	@Override
	public boolean startObject () throws ParseException, IOException
	{
	    documentHandler.newDoc();
	    setHandler( documentHandler );
	    return true;
	}
    }

    private class DocumentHandler extends FailingHandler
    {
    private String currentKey;
    private Document doc;
    private boolean sub;

	public DocumentHandler( boolean sub )
	{
	    this.sub = sub;
	}

	public void newDoc()
	{
	    doc = new Document();
	    doc.setAttr( Document.SERVER_RELEVANCE_KEY, Integer.toString(relevance) );
	    if( !sub ) relevance++;
	}

	public Document getDoc()
	{
	    return doc;
	}

	@Override
	public boolean endObject () throws ParseException, IOException
	{
	    if( sub )
	    {
		setHandler( mergedDocsHandler );
	    }
	    else
	    {
		setHandler( hitsArrayHandler );
		collector.collect( doc );
	    }
	    return currentHandler.endObject();
	}

	@Override
	public boolean primitive (Object value) throws ParseException, IOException
	{
	    String sValue = value == null ? null : String.valueOf(value);
	    doc.setAttr( currentKey, sValue );
	    return true;
	}

	@Override
	public boolean endObjectEntry() throws ParseException, IOException
	{
	    return true;
	}
	
	@Override
	public boolean startObjectEntry( String key ) throws ParseException, IOException
	{
	    if( key.equalsIgnoreCase("merged_docs") )
	    {
		mergedDocsHandler.setRootDoc( doc );
		setHandler( mergedDocsHandler );
		return true;
	    }
	    currentKey = key;
	    return true;
	}
    }

    private class MergedDocsHandler extends FailingHandler
    {
    private Document rootDoc;

	public void setRootDoc( Document doc )
	{
	    rootDoc = doc;
	}

	@Override
	public boolean startArray () throws ParseException, IOException
	{
	    return true;
	}

	@Override
	public boolean endObject () throws ParseException, IOException
	{
	    rootDoc.addMerged( subDocumentHandler.getDoc() );
	    return true;
	}

	@Override
	public boolean startObject() throws ParseException, IOException
	{
	    subDocumentHandler.newDoc();
	    setHandler( subDocumentHandler );
	    return true;
	}

	@Override
	public boolean endArray () throws ParseException, IOException
	{
	    setHandler( documentHandler );
	    return true;
	}
    }

    private class FailingHandler implements ContentHandler
    {
	@Override
	public boolean endArray () throws ParseException, IOException
    	{
    	    throw new ParseException( parent.getPosition(), ParseException.ERROR_UNEXPECTED_TOKEN, this.getClass().getName() );
    	}

	@Override
        public void endJSON () throws ParseException, IOException
    	{
    	    throw new ParseException( parent.getPosition(), ParseException.ERROR_UNEXPECTED_TOKEN, this.getClass().getName() );
    	}

	@Override
    	public boolean endObject () throws ParseException, IOException
    	{
    	    throw new ParseException( parent.getPosition(), ParseException.ERROR_UNEXPECTED_TOKEN, this.getClass().getName() );
    	}

	@Override
    	public boolean endObjectEntry () throws ParseException, IOException
    	{
    	    throw new ParseException( parent.getPosition(), ParseException.ERROR_UNEXPECTED_TOKEN, this.getClass().getName() );
    	}

	@Override
    	public boolean primitive (Object value) throws ParseException, IOException
    	{
    	    throw new ParseException( parent.getPosition(), ParseException.ERROR_UNEXPECTED_TOKEN, this.getClass().getName() );
    	}

	@Override
    	public boolean startArray () throws ParseException, IOException
    	{
    	    throw new ParseException( parent.getPosition(), ParseException.ERROR_UNEXPECTED_TOKEN, this.getClass().getName() );
    	}

	@Override
    	public void startJSON () throws ParseException, IOException
    	{
    	    throw new ParseException( parent.getPosition(), ParseException.ERROR_UNEXPECTED_TOKEN, this.getClass().getName() );
    	}

	@Override
    	public boolean startObject () throws ParseException, IOException
    	{
    	    throw new ParseException( parent.getPosition(), ParseException.ERROR_UNEXPECTED_TOKEN, this.getClass().getName() );
    	}
    	    
	@Override
    	public boolean startObjectEntry (String key) throws ParseException, IOException
    	{
    	    throw new ParseException( parent.getPosition(), ParseException.ERROR_UNEXPECTED_TOKEN, this.getClass().getName() );
    	}
    }

}
