package ru.yandex.msearch.proxy.search;

import java.util.LinkedList;
import java.util.List;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.io.Reader;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;

import org.apache.xerces.impl.io.UTF8Reader;

//import org.json.*;
import org.json.simple.JSONObject;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.apache.http.client.*;
import org.apache.http.impl.client.*;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.entity.StringEntity;
import org.apache.http.client.methods.HttpPost;

import ru.yandex.http.util.client.measurable.MeasurableHttpContext;

import ru.yandex.logger.BackendAccessLoggerConfigDefaults;

import ru.yandex.msearch.proxy.document.Document;
import ru.yandex.msearch.proxy.logger.Logger;
import ru.yandex.msearch.proxy.searchmap.SearchMap;
import ru.yandex.msearch.proxy.collector.Collector;
import ru.yandex.msearch.proxy.httpclient.CommonHttpClient;
import ru.yandex.msearch.proxy.HttpServer;

class LuceneServer extends ServerFactory.ServerIF
{

private String request;
private SearchMap.Host host;
private HttpRequestRetryHandler httpRetryHandler = new DefaultHttpRequestRetryHandler( 0, false );
private int readTimeout = 7000;
private boolean makePost = false;
private final HttpServer.RequestContext ctx;

    public LuceneServer(SearchMap.Host host, HttpServer.RequestContext ctx)
    {
	this.host = host;
	this.ctx = ctx;
    }

    public boolean makeRequest( HttpServer.HttpParams params, LinkedList<SearchMap.User> users ) throws Exception
    {
	request = "";
	Iterator<String> iter = params.keysIterator();
        boolean first = true;
        while( iter.hasNext() )
        {
	    String key = iter.next();
	    if( key.equals("user") ) continue;
	    if( key.equals("format") ) continue;
	    if( key.equals("getfields") ) continue;
	    if( key.equals("offset") ) continue;
	    if( key.equals("length") ) continue;
	    if( first ) first = false;
	    else request += "&";
	    
	    String value = params.get(key);
	    if( value != null )
		request += key + "=" + URLEncoder.encode( value, "utf-8" );
	    else
		request += key;
	}

	int offset;
	int length;
	try
	{
	    offset = Integer.parseInt( params.get("offset") );
	}
	catch( Exception e )
	{
	    offset = 0;
	}
	
	try
	{
	    length = Integer.parseInt( params.get("length") );
	}
	catch( Exception e )
	{
	    length = -1;
	}
	
//	if( offset != 0 ) request += "&offset=" + offset;
	if( length != -1 )
	{
	    if( params.get("near") != null )
	    {
		request += "&offset=" + offset + "&length=" + length;
	    }
	    else
	    {
		request += "&length=" + (offset + length);
	    }
	}

        request += "&format=json";
        String getFields = params.get("getfields");
        if( getFields == null ) getFields = "mid,received_date";
        else
        {
    	    List<String> gf = Arrays.asList(getFields.split(","));
    	    if( !gf.contains("mid") ) getFields += ",mid";
	    if( !gf.contains("received_date") ) getFields += ",received_date";
	}
	
	request += "&getfields=" + URLEncoder.encode( getFields, "utf-8" );

//	int maxUsers = usersPerSearch < queue.size() ? usersPerSearch : queue.size();
	SearchMap.User user = users.removeFirst();
	request += "&user=" + user.uid;
	makePost = false;
	readTimeout = 7000;
	if( users.size() > 0 )
	{
	    if( users.size() > 100 )
	    {
//		makePost = true;
		readTimeout = 30000;
	    }
	    String sharedSuids = "&shared_suids=";
	    Iterator<SearchMap.User> u = users.iterator();
	    int i = 0;
	    while( u.hasNext() )
	    {
		user = u.next();
	        if( i++ > 0 ) sharedSuids += ";";
		sharedSuids += user.uid;
	    }
	    request += sharedSuids;
	}
	return true;
    }

    @Override
    public InputStream doRequest() throws Exception
    {
	HttpResponse response = null;
	try
	{
	    ctx.log.debug("requesting " + "http://" + host.url + "/?" + request);
	    RequestConfig config = RequestConfig.custom()
	            .setSocketTimeout( readTimeout )
	            .setConnectTimeout( 500 )
	            .setExpectContinueEnabled( false )
	            .setStaleConnectionCheckEnabled( false )
	            .build();
	    HttpClient httpClient = CommonHttpClient.httpClientBuilder
	            .setDefaultRequestConfig(config)
	            .setRetryHandler( httpRetryHandler )
	            .build();
	    if( makePost )
	    {
		HttpPost httpPost = new HttpPost( "http://" + host.url + "/" );
		httpPost.setHeader( "Accept-Encoding", "gzip" );
                httpPost.setHeader(
                    BackendAccessLoggerConfigDefaults.X_PROXY_SESSION_ID,
                    ctx.getSessionId());
                httpPost.setHeader( ctx.referer() );
		httpPost.setEntity( new StringEntity( request ) );
        MeasurableHttpContext context = new MeasurableHttpContext();
        response = httpClient.execute( httpPost, context );
        ctx.log.info(context.finAndGetInfo());
	    }
	    else
	    {
		HttpGet httpGet = new HttpGet( "http://" + host.url +"/?" + request );
                httpGet.setHeader(
                    BackendAccessLoggerConfigDefaults.X_PROXY_SESSION_ID,
                    ctx.getSessionId());
                httpGet.setHeader( ctx.referer() );
        MeasurableHttpContext context = new MeasurableHttpContext();
        response = httpClient.execute( httpGet, context );
        ctx.log.info(context.finAndGetInfo());
	    }

	    HttpEntity httpEntity = response.getEntity();
	    if( httpEntity != null ) return httpEntity.getContent();
	}
    catch( SocketTimeoutException e )
    {
        ctx.log.err("request failed: " + e.toString() + " : " + host.url);
        throw e;
    }
	catch( Exception e )
	{
	    ctx.log.err("request failed: " + e.toString() + " : " + request);
	    throw e;
	}
        throw new IOException("request failed: " + response.getStatusLine() + " : " + request);
    }

    @SuppressWarnings("unchecked")
    private Document parseDoc( JSONObject json ) throws org.json.JSONException
    {
        Document doc = new Document();

//        Iterator iter = json.keys();
	Iterator<Map.Entry<String,Object>> iter = json.entrySet().iterator();
        while( iter.hasNext() )
        {
    	    Map.Entry<String,Object> entry = iter.next();
    	    String key = entry.getKey();
	    if( key.equals("merged_docs") )
	    {
	        JSONArray docsArray = (JSONArray)json.get("merged_docs");
	        for( int i = 0; i < docsArray.size(); i++ )
	        {
		    doc.addMerged( parseDoc( (JSONObject)docsArray.get(i) ) );
		}
	    }
	    else
	    {
//	        String value = json.isNull(key) ? null : json.getString(key);
		Object value = entry.getValue();
		String stringValue = value == null ? null : (String)value;
	        doc.setAttr(key,stringValue);
	    }
	}

	return doc;
    }

    public void parseAnswer( HttpServer.RequestContext ctx, Reader in, Collector collector ) throws Exception
    {
	JSONParser parser = new JSONParser();
//	SajParser parser = new SajParser();
//	LuceneJSONListener transformer = new LuceneJSONListener( ctx, collector );
//	parser.parse( in, transformer );
	LuceneJSONTransformer transformer = new LuceneJSONTransformer( parser, ctx, collector );
	ctx.checkAbort();
	parser.parse( in, transformer );
    }
	
    @SuppressWarnings("unchecked")
    public void parseAnswerDOM( Reader in, Collector collector ) throws Exception
    {
	JSONParser parser = new JSONParser();
//        JSONTokener tokener = new JSONTokener(in);
//        JSONObject json = new JSONObject( tokener );
	JSONObject json = (JSONObject)parser.parse( in );
        if( !json.containsKey("hitsCount") || !json.containsKey("hitsArray") )
        {
	    ctx.log.err("Invalid json received from: " + host.url);
	    return;
	}
	collector.incTotalCount( ((Number)json.get("hitsCount")).intValue() );
//	JSONArray hitsArray = json.getJSONArray("hitsArray");
	JSONArray hitsArray = (JSONArray)json.get("hitsArray");
	ctx.log.debug("hitsCount: " + ((Number)json.get("hitsCount")).intValue() + " for " + request);
	Iterator<Object> iter = hitsArray.iterator();
//	for( int i = 0; i < hitsArray.length(); i++ )
	int i = 0;
	while( iter.hasNext() )
	{
	    JSONObject obj = (JSONObject)iter.next();
	    Document doc;
	    try
	    {
	        doc = parseDoc( obj );
	        if( doc.getAttr("_relevant_") == null ) doc.setAttr( "_relevant_", String.format( "%010d", i++ ) );
	        collector.collect( doc );
	    }
	    catch( org.json.JSONException e )
	    {
	        ctx.log.err("Error parsing document");
	        e.printStackTrace();
	    }
	}
    }
}

