package ru.yandex.msearch.proxy.search;

import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Iterator;
import java.util.Vector;
import java.io.PrintStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.BufferedInputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.IOException;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

import org.apache.xerces.impl.io.UTF8Reader;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.HttpServer.HttpParams;
import ru.yandex.msearch.proxy.MsearchProxyException;
import ru.yandex.msearch.proxy.collector.Collector;
import ru.yandex.msearch.proxy.logger.Logger;
import ru.yandex.msearch.proxy.searchmap.SearchMap;
import ru.yandex.msearch.proxy.searchmap.SearchMap.Host;
import ru.yandex.msearch.proxy.searchmap.SearchMap.User;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class Searcher
{

private int usersPerSearch;
private SearchMap searchMap;
private HashMap<SearchMap.Host,HostRequester> requestersMap;
private HashMap<SearchMap.Host,Bucket> preparedBuckets;
private volatile int running = 0;
private int finished = 0;
private int failed = 0;
private Collector collector;
private HttpParams params;
private HttpServer.RequestContext ctx;
private static ThreadPoolExecutor executor = null;
private final ConcurrentHashMap<String, SearchMap.User> completed =
    new ConcurrentHashMap<>();
private boolean accountCompleted = false;

    private static class ThreadInfo
    {
    public Thread	thread;
    public long		lastUseTime;

	public ThreadInfo( Thread t )
	{
	    this.thread = t;
	    lastUseTime = System.currentTimeMillis();
	}
    }

    public static void init(final IniConfig config) throws ConfigException
    {
        int threads = config.getInt("threads", 150);
        int threadsMax = config.getInt("threads_max", 300);
	executor = new ThreadPoolExecutor(
	    threads,
	    threadsMax,
	    10,
	    TimeUnit.SECONDS,
	    new LinkedBlockingQueue<Runnable>());
    }

    public Searcher( HttpServer.RequestContext ctx, int usersPerSearch, SearchMap searchMap, HttpServer.HttpParams params, Collector collector ) throws MsearchProxyException
    {
	this.usersPerSearch = usersPerSearch;
	this.searchMap = searchMap;
	this.params = params;
	this.collector = collector;
	this.preparedBuckets = new HashMap<SearchMap.Host,Bucket>();
	this.ctx = ctx;
    }

    public void setAccountCompleted(final boolean accountCompleted) {
        this.accountCompleted = accountCompleted;
    }

    public void search( String db, String[] users ) throws MsearchProxyException
    {
	fillQueue(db, users);
//	startRequesters(collector, params);
	boolean stopped = false;
	try
	{
	
	while( running > 0 )
	{
	    synchronized(this)
	    {
		try
		{
		    wait(100);
		}
		catch( java.lang.InterruptedException e )
		{
		    continue;
		}
		Iterator<Map.Entry<SearchMap.Host,HostRequester> > iter = requestersMap.entrySet().iterator();
		int finished = 0;
		while( iter.hasNext() )
		{
		    Map.Entry<SearchMap.Host,HostRequester> el = iter.next();
		    HostRequester requester = el.getValue();
		    if( requester.finished() ) finished++;
		}
//		System.err.println( "finished: " + finished + " / running: " + running);
		if( finished >= running ) break;
	    }
	    ctx.checkAbort();
	}
//	finished.
	synchronized( this )
	{
	    Iterator<Map.Entry<SearchMap.Host,HostRequester> > iter = requestersMap.entrySet().iterator();
	    int finished = 0;
	    while( iter.hasNext() )
	    {
		Map.Entry<SearchMap.Host,HostRequester> el = iter.next();
		HostRequester requester = el.getValue();
		requester.quit();
	    }
	    stopped = true;
	}
	
	}
	finally
	{
	    if( !stopped ) abort();
	}
    }
    
    public void abort()
    {
	synchronized( this )
	{
	    Iterator<Map.Entry<SearchMap.Host,HostRequester> > iter = requestersMap.entrySet().iterator();
	    int finished = 0;
	    while( iter.hasNext() )
	    {
		Map.Entry<SearchMap.Host,HostRequester> el = iter.next();
		HostRequester requester = el.getValue();
		requester.forceQuit();
	    }
	}
    }
/*    
    private void startRequesters( Collector collector, Map<String,String> params )
    {
	Iterator<Map.Entry<SearchMap.Host,HostRequester> > iter = requestersMap.entrySet().iterator();
	while( iter.hasNext() )
	{
	    Map.Entry<SearchMap.Host,HostRequester> el = iter.next();
	    HostRequester requester = el.getValue();
	    requester.setCollector( collector );
	    requester.setParams( params );
	    running++;
	    (new Thread(requester,"HostRequester<" + el.getKey().url + ">")).start();
	}
    }
*/
    private void failed( HostRequester hr )
    {
	synchronized( this )
	{
//	    System.err.println( "Failed hr: " + hr );
	    if( finished >= running ) System.err.println( "Invalid state: all threads must be already stoped!!!" );
	    failed++;
	    hr.quit();
	    LinkedList<Bucket> failedBuckets = hr.getBuckets();
	    Iterator<Bucket> bucketsIter = failedBuckets.iterator();
	    while( bucketsIter.hasNext() )
	    {
//		System.err.println( "buckets iter" );
		Bucket b = bucketsIter.next();
		LinkedList<SearchMap.User> users = b.getUsers();
		dispatchUsers( users );
//		Iterator<SearchMap.User> usersIter = users.iterator();
//		while( usersIter.hasNext() )
//		{
//		    SearchMap.User user = usersIter.next();
//		}
	    }
//   for( int i = 0; i < queue.size(); i++ )
//   {
//		SearchMap.User user = queue.get(i);
//	    }
	    running--;
//	    fireRequesters();
	    dispatchBuckets();
	    notify();
	}
    }
    
    private void dispatchUsers( LinkedList<SearchMap.User> users )
    {
	Iterator<SearchMap.User> usersIter = users.iterator();
	while( usersIter.hasNext() )
	{
	    SearchMap.User user = usersIter.next();
	    SearchMap.Host host;
	    while( (host = user.getNextHost()) != null )
	    {
	        HostRequester requester = getRequester(host);
	        if( requester == null ) continue;
	        if( requester.failed() ) continue;
//		    requester.addUser( user );
	        Bucket b = preparedBuckets.get( host );
	        if( b == null )
	        {
		    b = new Bucket();
		    preparedBuckets.put( host, b );
		}
		b.addUser( user );
//		Logger.debug( ctx.getSessionId() + ": bucket for <" + host + "> adding user: " + user.uid );
		if( b.size() > usersPerSearch )
		{
		    requester.addBucket( b );
//		    requester.fire();
		    b = new Bucket();
		    preparedBuckets.put( host, b );
		}
		break;
	    }
//	    if( host == null ) System.err.println( "User: " + user + " cannot be bound to any server" );
	}
//	Iterator<Map.Entry<SearchMap.Host,Bucket>> 
    }
    
    private void dispatchBuckets()
    {
	boolean hasFailed = false;
	Iterator<Map.Entry<SearchMap.Host,Bucket>> iter = preparedBuckets.entrySet().iterator();
	LinkedList<Bucket> failed = null;
	while( iter.hasNext() )
	{
	    Map.Entry<SearchMap.Host,Bucket> e = iter.next();
	    SearchMap.Host host = e.getKey();
	    Bucket b = e.getValue();
	    if( b.size() == 0 ) continue;
	    HostRequester requester = getRequester(host);
	    if( requester == null )
	    {
		hasFailed = true;
		if( failed == null ) failed = new LinkedList<Bucket>();
		failed.add( b );
		//dispatchUsers( b.getUsers() );
	    }
	    else
	    {
		if( !hasFailed )
		{
		    requester.addBucket( b );
		}
	    }
	}
	if( hasFailed )
	{
	    Iterator<Bucket> failedIter = failed.iterator();
	    while( failedIter.hasNext() )
	    {
		Bucket b = failedIter.next();
		dispatchUsers( b.getUsers() );
	    }
	    dispatchBuckets();
	}
    }
    
    private void finished()
    {
	synchronized( this )
	{
	    notify();
	}
    }
    
    private void fillQueue( String db, String[] users )
    {
	LinkedList<SearchMap.User> queue = new LinkedList<SearchMap.User>();
	requestersMap = new HashMap<SearchMap.Host,HostRequester>();
    completed.clear();
    for( int i = 0; i < users.length; i++ )
	{
//	    Logger.debug( ctx.getSessionId() + ": user[" + i + "]: " + users[i] + " / " + users.length );
	    User user = new User();
	    user.uid = users[i];
	    user.hosts = searchMap.getHosts( db, user.uid );
	    
	    if( user.hosts == null )
	    {
		ctx.log.err( "user <"+user.uid+"> cannot be bound to any server" );
		continue;
	    }

//	    Logger.debug( ctx.getSessionId() + ": user[" + i + "].host: " + user.hosts );

	    queue.add( user );
	}
	dispatchUsers( queue );
	dispatchBuckets();
    }

    void onComplete(final Bucket bucket) {
        if (accountCompleted) {
            for (SearchMap.User user: bucket.getUsers()) {
                completed.put(user.uid, user);
            }
        }
    }

    public boolean isCompleted(final String[] users) {
        if (!accountCompleted) {
            ctx.log.err("check isCompleted(String[]) without accountCompleted");
        }
        return completed.keySet().containsAll(Arrays.asList(users));
    }

//    private HostRequester newRequester( String sessionId, HTTPServer.RequestContext ctx, SearchMap.Host host, int usersPerSearch, Searcher searcher )
//    {
//	HostRequester requester = new HostRequester( sessionId, ctx, host, usersPerSearch, this );
//	executor.execute( requester );
//	return requester;
//    }

    private HostRequester getRequester( SearchMap.Host host )
    {
	HostRequester requester = requestersMap.get(host);
	if( requester == null )
	{
	    try
	    {
		requester = new HostRequester( ctx, host, usersPerSearch, this );
	    }
	    catch( Throwable e )
	    {
		ctx.log.err( "Can't create requester instance for host: " + host.url + ": " + Logger.exception(e) );
		return null;
	    }
	    requester.setCollector( collector );
	    requester.setParams( params );
	    running++;
	    executor.execute( requester );
	}
	requestersMap.put( host, requester );
	return requester;
    }

    private static class Bucket
    {
	private LinkedList<SearchMap.User> users;
	public Bucket()
	{
	    users = new LinkedList<SearchMap.User>();
	}
	
	public void addUser( SearchMap.User user )
	{
	    users.add( user );
	}
	
	public LinkedList<SearchMap.User> getUsers()
	{
	    return users;
	}
	
	public int size()
	{
	    return users.size();

	}
    }

    private static class HostRequester implements Runnable
    {
	private int usersPerSearch;
	Searcher searcher;
	SearchMap.Host host;
	private LinkedList<Bucket> queue;
	private Bucket current;
	public boolean quit = false;
	HttpParams params;
	Collector collector = null;
	private boolean failed = false;
	private ServerFactory.ServerIF server;
	private HttpServer.RequestContext ctx;
	
	public HostRequester( HttpServer.RequestContext ctx, SearchMap.Host host, int usersPerSearch, Searcher searcher ) throws Exception
	{
	    this.ctx = ctx;
	    this.host = host;

	    queue = new LinkedList<Bucket>();
	    this.usersPerSearch = usersPerSearch;
	    this.searcher = searcher;
	    this.server = ServerFactory.getServer(host, ctx);
	}
	
	public LinkedList<Bucket> getBuckets()
	{
//	    Linked
	    return queue;
	}
	
	public void setParams( HttpParams params )
	{
	    this.params = params;
	}
	
	public void setCollector( Collector collector )
	{
	    this.collector = collector;
	}
	
	public synchronized void addBucket( Bucket b )
	{
	    queue.add( b );
	    notify();
	}
	
	public synchronized void copyUsers( HostRequester other )
	{
	    synchronized(this)
	    {
		queue.addAll(other.queue);
	    }
	}
	
	private synchronized boolean makeRequest( Bucket b ) throws Exception
	{
	    java.util.LinkedList<SearchMap.User> clone = new java.util.LinkedList<SearchMap.User>();
	    clone.addAll( b.getUsers() );
	    return server.makeRequest( params, clone );
	}

	public void doRequest(final Bucket bucket) {
	    long start = System.currentTimeMillis();
	    try (Reader in =
                    new BufferedReader(new UTF8Reader(server.doRequest())))
            {
                server.parseAnswer(ctx, in, collector);
                searcher.onComplete(bucket);
	    } catch (Throwable t) {
                ctx.log.err(
                    "error parsing results from server <" + host + '>',
                    t);
		failed = true;
		searcher.failed(this);
	    } finally {
		ctx.log.info(
                    "request time <" + host + ">: "
                    + (System.currentTimeMillis() - start));
	    }
	}

	public synchronized LinkedList<Bucket> getQueue()
	{
	    return queue;
	}
	
	public synchronized boolean finished()
	{
	    return queue.size() <= 0;
	}
	
	public boolean failed()
	{
	    return failed;
	}
	
	private synchronized int getQueueSize()
	{
	    return queue.size();
	}
	
	public void run()
	{
	    try
	    {
//		Thread.currentThread().setName( "HostRequester<" + ctx.getSessionId() +">_" + host.url );
		while( !quit )
		{
		    Bucket b = null;
		    if( getQueueSize() <= 0 || failed )
		    {
			searcher.finished();
//		finished = true;
//		searcher.finished();
			synchronized( this )
			{
			    try
			    {
		    		wait( 1000 );
			    }
			    catch( InterruptedException e )
			    {
				return;
			    }
			}
//			continue;
		    }
		    if( failed ) continue;
		    if( quit ) break;
		    synchronized( this )
		    {
			if( queue.size() > 0 )
			{
			    b = queue.getFirst();
			}
			else
			{
			    continue;
			}
		    }
		    try
		    {
			if( makeRequest( b ) )
			{
			    doRequest(b);
			}
		    }
		    catch( Exception e )
		    {
			ctx.log.err( "can't prepare request for server <" + host + ">: " + e.toString() );
			e.printStackTrace();
		    }
		    if( !failed )
		    {
			synchronized( this )
			{
			    queue.removeFirst();
			}
		    }
		}
//		Thread.currentThread().setName( "HostRequester_polled" );
	    }
	    catch( Throwable e )
	    {
		ctx.log.err( "Fatal internal error at trying to run host requester: " + Logger.exception( e ) );
	    }
	}

	public void quit()
	{
    	    synchronized(this)
            {
        	quit = true;
        	notify();
            }
	}

	public void forceQuit()
	{
	    Thread.currentThread().interrupt();
	}
    }
}

