package ru.yandex.msearch.proxy.search;

import java.util.LinkedList;
import java.util.Map;
import java.io.Reader;
import java.io.InputStream;

import ru.yandex.msearch.proxy.logger.Logger;
import ru.yandex.msearch.proxy.collector.Collector;
import ru.yandex.msearch.proxy.searchmap.SearchMap;
import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.HttpServer.HttpParams;

public class ServerFactory
{
    public static abstract class ServerIF
    {
        public abstract boolean makeRequest( HttpParams params, LinkedList<SearchMap.User> users ) throws Exception;
        public abstract InputStream doRequest() throws Exception;
        public abstract void parseAnswer( HttpServer.RequestContext ctx, Reader in, Collector collector ) throws Exception;
    }

    public static ServerIF getServer(SearchMap.Host host, HttpServer.RequestContext ctx) throws Exception
    {
	return new LuceneServer(host, ctx);
    }
}

