package ru.yandex.msearch.proxy.searchmap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.zip.CRC32;

import ru.yandex.msearch.proxy.logger.Logger;

import ru.yandex.search.prefix.Prefix;

public class SearchMap
{
public static SearchMap searchMap = null;

private String mapfile;
private Watcher watcher = null;
private Map<String,Db> dbMap = null;
private long lastTs = 0;
private long lastCRC = 0;
private HashMap<Host,Host> hosts = new HashMap<Host,Host>();
private HashMap<String,String> stringsMap = new HashMap<String,String>();

    static public class User
    {
	public LinkedList<SearchMap.Host> hosts;
	public String uid;
	boolean finished = false;
	
	public SearchMap.Host getNextHost()
	{
//	    System.err.println( "hosts.size: " + hosts.size() );
	    if( hosts == null ) return null;
	    if( hosts.size() == 0 ) return null;
	    return hosts.removeFirst();
	}
	
    }

    public static class Db
    {
	String db;
	private Vector<ArrayList<Host> > shards;
	
	Db()
	{
	    shards = new Vector<ArrayList<Host> >(65535);
	    for( int i = 0; i < 65536; i++ )
	    {
		shards.add( new ArrayList<Host>(2) );
	    }
	}
    }

    public static class Host
    {
	public String url;
	public Map<String,String> params = new HashMap<String,String>();

	@Override
	public boolean equals( Object other )
	{
	    Host otherHost = (Host)other;
	    if( !otherHost.url.equals(url) ) return false;
	    if( !otherHost.params.equals(params) ) return false;
	    return true;
	}

        @Override
        public int hashCode()
        {
    	    return url.hashCode();
	}

	public String toString()
	{
	    return url;
	}
    }

    public SearchMap(final String file) {
	mapfile = file;
	startWatcher();
    }

    public SearchMap(final Reader reader) throws IOException {
        parseSearchMap(new BufferedReader(reader));
    }

    public static void init(final String path) {
	searchMap = new SearchMap(path);
    }

    public static void init(final Reader reader) throws IOException {
        searchMap = new SearchMap(reader);
    }

    public static SearchMap getInstance()
    {
	return searchMap;
    }

    private void startWatcher()
    {
	watcher = new Watcher();
	(new Thread(watcher, "SearchMapWatcher")).start();
    }

    public LinkedList<Host> getHosts( String dbStr, String user )
    {
        long uid;
        try
        {
            uid = Math.abs(Long.parseLong( user ));
        }
        catch( Exception e )
        {
            return null;
        }
        return getHosts( dbStr, uid );
    }

    public LinkedList<Host> getHosts( String dbStr, Prefix prefix )
    {
        return getHosts( dbStr, prefix.hash() );
    }

    public LinkedList<Host> getHosts( String dbStr, long uid )
    {
	Map<String,Db> dbMap;
	synchronized(this)
	{
	    dbMap = this.dbMap;
	}
    
	Db db = dbMap.get( dbStr );
	if( db == null ) return null;

	int shard = (int)(uid % 65534);
//	LinkedList<Host> hosts = (LinkedList<Host>)(db.shards.get(shard).clone());
	LinkedList<Host> hosts = new LinkedList<Host>( db.shards.get(shard) );
	int first = (int)(uid % hosts.size());
	if( first > 0 )
	{
	    Host f = hosts.remove(first);
	    hosts.add( 0, f );
	}
	return hosts;
    }

    private final String intern( String str )
    {
	String old = stringsMap.get( str );
	if( old == null )
	{
	    stringsMap.put( str, str );
	    return str;
	}
	return old;
    }

    private String[] split( String str, String needle )
    {
	String[] parts = str.split(needle);
	if( parts == null ) return null;
	for( int i = 0; i < parts.length; i++ )
	{
	    parts[i] = intern( parts[i] );
	}
	return parts;
    }

    private void parseSearchMap() throws IOException
    {
	Logger.info("Parsing searchmap: " + mapfile);
	File file = new File(mapfile);
	BufferedReader fs = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
	String line = null;

	CRC32 crc = new CRC32();
	while( (line = fs.readLine()) != null )
	{
	    crc.update( line.getBytes() );
	}
	fs.close();
	if( crc.getValue() == lastCRC )
	{
	    Logger.info( "searchmap CRC32 has not changed. skiping." );
	    lastTs = file.lastModified();
	    return;
	}
	lastCRC = crc.getValue();
        parseSearchMap(new BufferedReader(new InputStreamReader(new FileInputStream(file))));
	lastTs = file.lastModified();
    }

    private void parseSearchMap(final BufferedReader fs) throws IOException {
	Map<String,Db> dbMap = new HashMap<String,Db>();
        String line;
	while( (line = fs.readLine()) != null )
	{
	    line = line.trim();
	    if( line.length() == 0 ) continue;
	    if( line.startsWith("#") || line.startsWith(";") || line.startsWith("//") ) continue;

	    String[] dbAndParams = split( line, " " );
	    if( dbAndParams.length < 2 ) continue;
	    String dbStr = dbAndParams[0];
	    String[] params = split( dbAndParams[1], "," );

	    Host host = new Host();
	    String shards = "0-65534";
	    for( int i = 0; i < params.length; i++ )
	    {
                int sep = params[i].indexOf( ':' );
                if( sep == -1 )
                {
                    host.params.put( params[i], "" );
                }
                else
                {
                    String key = params[i].substring( 0, sep );
                    String value = params[i].substring( sep + 1 );
		    if( key.equals("shards" ) )
		    {
			shards = value;
		    }
		    else
		    {
			host.params.put( key, value );
		    }
		}
	    }
	    String skip = host.params.get("skip_search");
	    if( skip != null && skip.equals("yes") ) continue;
	    host.url = host.params.get("host") + ":" + host.params.get("search_port");
	    String[] shardsBE = split( shards, "-" );
	    int start = 0;
	    int end = 65534;
	    try
	    {
		if( shardsBE.length == 2  )
		{
		    start = Integer.parseInt( shardsBE[0] );
		    end = Integer.parseInt( shardsBE[1] );
		}
	    }
	    catch( Exception e ) {}

            if( !hosts.containsKey(host) ) hosts.put( host, host );
            host = hosts.get( host );

            String[] dbList = dbStr.split(",");
            for (String oneDb : dbList) {
                Db db = dbMap.get(oneDb);
                if (db == null) {
                    db = new Db();
                    dbMap.put(oneDb, db);
                }
                for (int i = start; i <= end; i++) {
                    db.shards.get(i).add(host);
                }
            }

	}
	fs.close();
	stringsMap.clear();
	synchronized(this)
	{
	    stringsMap.clear();
	    hosts.clear();
	    this.dbMap = dbMap;
	}
	Logger.info( "Parsing searchmap finished" );
    }
    
    private boolean fileModified()
    {
	return lastTs != (new File(mapfile)).lastModified();
    }
    
    class Watcher implements Runnable
    {
	public Watcher()
	{
	}
    
	public void run()
	{
	    while( true )
	    {
//		System.err.println( "Checking searchmap" );
		if( dbMap == null || fileModified() )
		{
		    try
		    {
			try
			{
			    if( dbMap != null ) Thread.sleep( 1000 );
			}
			catch( java.lang.InterruptedException e )
			{
			}
			parseSearchMap();
		    }
		    catch( IOException e )
		    {
			e.printStackTrace();
		    }
		}
                /* nothing to do */
                try
                {
            	    Thread.sleep( 5000 );
//            	    synchronized(this)
//            	    {
////                	wait(5000);
//        	    }
                }
                catch( InterruptedException e )
                {
                    /* should not happen */
                    continue;
                }
	    }
	}
    }
    
}
