package ru.yandex.msearch.proxy.socheck;

import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.logger.Logger;

public class RequestsLogger<T> implements FutureCallback<T> {
    private final HttpServer.RequestContext ctx;
    private final int step;

    public RequestsLogger(final HttpServer.RequestContext ctx,
        final int step)
    {
        this.ctx = ctx;
        this.step = step;
    }

    @Override
    public void completed(final T t) {
        ctx.log.debug("socheck: Got step " + step + " response from SO: " + t);
    }

    @Override
    public void failed(final Exception e) {
        ctx.log.warn("socheck: SO step " + step + " request failed: "
            + Logger.exception(e));
    }

    @Override
    public void cancelled() {
        ctx.log.warn("socheck: SO step " + step + " request cancelled");
    }
}

