package ru.yandex.msearch.proxy.socheck;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.JsonAsyncConsumer;

import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.SparseStringCollectorsFactory;

public class SoCheckConsumer extends JsonAsyncConsumer<SoCheck.Result> {
    private final SoCheckJsonHandler handler;

    public SoCheckConsumer(final HttpEntity entity) throws HttpException {
        this(entity, new SoCheckJsonHandler());
    }

    private SoCheckConsumer(
        final HttpEntity entity,
        final SoCheckJsonHandler handler)
        throws HttpException
    {
        super(entity, handler, SparseStringCollectorsFactory.INSTANCE);
        this.handler = handler;
    }

    @Override
    protected SoCheck.Result doBuildResult(final HttpContext context)
        throws JsonException
    {
        if (handler.isSpam() == null) {
            throw new JsonException("Spam check result not found in json");
        } else if (handler.isSpam() == Boolean.TRUE) {
            return SoCheck.Result.SPAM;
        } else {
            return SoCheck.Result.GOOD;
        }
    }
}


