package ru.yandex.msearch.proxy.socheck;

import java.io.Closeable;
import java.io.IOException;

import java.net.InetAddress;
import java.net.UnknownHostException;

import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.concurrent.SingleNamedThreadFactory;

import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.http.config.ImmutableHttpTargetConfig;

import ru.yandex.http.util.HttpStatusPredicates;

import ru.yandex.http.util.nio.LazyAsyncResponseConsumer;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;
import ru.yandex.http.util.nio.client.pool.AsyncNHttpClientConnectionManager;

import ru.yandex.parser.config.ConfigException;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.MsearchProxyException;
import ru.yandex.msearch.proxy.config.ImmutableMsearchProxyConfig;
import ru.yandex.msearch.proxy.config.ImmutableSoCheckConfig;
import ru.yandex.msearch.proxy.logger.Logger;

public class SoCheckFactory implements Closeable {
    private static final StatusCheckAsyncResponseConsumerFactory<
    SoCheck.Result> CONSUMER_FACTORY =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            SoCheckConsumerFactory.INSTANCE);

    private final SharedConnectingIOReactor reactor;
    private final ImmutableSoCheckConfig config;
    private final AsyncNHttpClientConnectionManager connManager;
    private final CloseableHttpAsyncClient client;
    private final String uri;
    private final String hostname;

    public SoCheckFactory(
        final SharedConnectingIOReactor reactor,
        final ImmutableSoCheckConfig config)
        throws UnknownHostException
    {
        this.reactor = reactor;
        this.config = config;
        connManager = new AsyncNHttpClientConnectionManager(reactor, config);
        client = AbstractAsyncClient.createBareClient(connManager, config);
        uri = config.uri().toASCIIString() + config.firstCgiSeparator()
            + "so_form_name=msearchproxyform&so_service=MSEARCH-PROXY&step=";
        hostname = InetAddress.getLocalHost().getHostName();
    }

    public SharedConnectingIOReactor reactor() {
        return reactor;
    }

    public ImmutableSoCheckConfig config() {
        return config;
    }

    public String hostname() {
        return hostname;
    }

    public void start() {
        client.start();
    }

    @Override
    public void close() throws IOException {
        client.close();
    }

    public Map<String, Object> status() {
        return connManager.status(true);
    }

    public SoCheck create(
        final HttpServer.HttpParams params,
        final HttpServer.RequestContext ctx)
    {
        return new HttpSoCheck(params, ctx, this);
    }

    public Future<SoCheck.Result> sendStep1Request(
        final String request,
        final HttpServer.RequestContext ctx)
    {
        try {
            String uri = this.uri + '1' + request;
            ctx.log.debug("socheck: Sending SO request: " + uri);
            HttpAsyncRequestProducer producer =
                HttpAsyncMethods.createGet(uri);
            return client.execute(
                producer,
                new LazyAsyncResponseConsumer<>(CONSUMER_FACTORY, producer),
                new RequestsLogger<SoCheck.Result>(ctx, 1));
        } catch (Exception e) {
            ctx.log.warn(
                "socheck: Error occured while sending step 1 request: "
                + Logger.exception(e));
            return null;
        }
    }

    public void sendStep2Request(final String request,
        final HttpServer.RequestContext ctx)
    {
        try {
            String uri = this.uri + '2' + request;
            ctx.log.debug("socheck: Sending SO step 2 request: " + uri);
            client.execute(
                new HttpGet(uri),
                new RequestsLogger<HttpResponse>(ctx, 2));
        } catch (Exception e) {
            ctx.log.warn(
                "socheck: Error occured while sending step 1 request: "
                + Logger.exception(e));
        }
    }
}

