package ru.yandex.msearch.proxy.socheck;

import java.util.List;

import ru.yandex.json.parser.JsonException;

import ru.yandex.json.xpath.PathComponent;
import ru.yandex.json.xpath.PrimitiveHandler;
import ru.yandex.json.xpath.ReportingPrimitiveHandler;

public class SoCheckJsonHandler implements PrimitiveHandler {
    private Boolean isSpam = null;

    public Boolean isSpam() {
        return isSpam;
    }

    @Override
    public void handle(final List<PathComponent> path, final Object value)
        throws JsonException
    {
        if (path.size() == 2
            && "spam".equals(path.get(1).name())
            && "check".equals(path.get(0).name()))
        {
            if (value instanceof Boolean) {
                isSpam = (Boolean) value;
            } else {
                ReportingPrimitiveHandler.INSTANCE.handle(path, value);
            }
        }
    }
}

