var Collector = Java.type('ru.yandex.lympho.LymphoSearchCollector');

var subscriptions_uids = %SUBSCRIPTIONS%;
var maxLength = %MAX_LENGTH%;
var output = context.out();
var length = 0;
var processedUids = 0;
var lasUidProcessed = "-1";
var curPrefixDocs = 0;
var currentPrefix;
var deadline = %DEADLINE%;
var SearchCallback = Java.extend(Collector, {
    document: function(doc, fields) {
        if (curPrefixDocs == 0) {
            output.key(currentPrefix);
            output.startArray();
        }

        output.startObject();
        for each (var field in fields) {
            output.key(field);
            output.value(doc.getString(field));
        }
        output.endObject();
        length += 1;
        curPrefixDocs += 1;
    }
});


output.startObject();
output.key("result");
output.startObject();
var callback = new SearchCallback();
for each (var uid in subscriptions_uids) {
    curPrefixDocs = 0;
    currentPrefix = uid;
    context.search("%QUERY_BASE%&prefix=" + uid, maxLength, callback);
    if (curPrefixDocs > 0) {
        output.endArray();
    }

    processedUids += 1;
    if (length >= maxLength || context.currentTimeMillis() > deadline) {
        break;
    }
}
output.endObject();
output.key("uids_processed");
output.value(processedUids);
output.key("uids_total");
output.value(subscriptions_uids.length);
output.key("last_uid");
output.value(uid);
output.endObject();

