#!/bin/bash
source $BSCONFIG_IDIR/msearch-proxy-config.sh

drop_ports="$SERVER_IPORT"

ip6_tunnel_names=`ip -6 tunnel show | cut -d":" -f1`
ip4_tunnel_names=`ip -4 tunnel show | cut -d":" -f1`

ip a | grep -Eq ': tun0' && ip4_tunnel_names="tun0"

# mail_search network
allowed_macroses="_GENCFG_MAIL_SEARCH_";
for macros in $allowed_macroses; do
 echo "Permitted macros is: $macros";
 hbf_nets=$(curl -sf "http://hbf.yandex.net/macros/$macros?trypo_format=dottedquad&format=text")

 if [ $? != "0" ]; then
    echo "Error when try to get macros networks through hbf api"
    exit 1;
 fi;

 for net in $hbf_nets; do
  if [ -z "$macros_networks" ]; then
   macros_networks="$net";
  else
   macros_networks="$macros_networks,$net";
  fi;
 done;
done;
# yasm BEWARE! dont use this construction on huge groups (ddos on OOPS)!
vlan688_nets=$(curl -s https://oops.yandex-team.ru/api/hosts/$PORTO_HOST/attributes/net_info | jq -r '.interfaces[] | select(.name == "vlan688") | .ips[]' | cut -d "/" -f 1)
if [ $? != "0" ]; then
    echo "Error when try to vlan688 addreses through oops api"
    exit 1;
fi;

source_ipv6_nets="$macros_networks";

for vlan688_net in $vlan688_nets; do
 source_ipv6_nets="$source_ipv6_nets,$vlan688_net";
done;

source_ipv6_nets=`echo $source_ipv6_nets | sed 's/^,*//';`

ip6_networks="::1";
#ipv6 tunnel networks
for tun in $ip6_tunnel_names; do
 for tun_addr in $(ip -6 addr show dev $tun | grep inet6 |tr -s " " | awk '{print $2}' | cut -d '/' -f 1); do
  ip6_networks="$ip6_networks,$tun_addr";
 done;
done;
ip6_networks=`echo $ip6_networks | sed 's/^,*//';`

ip4_networks="127.0.0.1";
#ipv4 tunnel networks
for ip4tun in $ip4_tunnel_names; do
    for tun_addr in $(ip -4 addr show dev $ip4tun | grep inet |tr -s " " | awk '{print $2}' | cut -d '/' -f 1); do
        ip4_networks="$ip4_networks,$tun_addr";
    done;
done;

ip4_networks=`echo $ip4_networks | sed 's/^,*//';`


# check ipv4
tunnel_rules_accept_ipv6=`sudo ip6tables -C mail_search -d $ip6_networks -p tcp -m multiport --dport $drop_ports -j ACCEPT; echo $?`
source_rules_accept_ipv6=`sudo ip6tables -C mail_search -s $source_ipv6_nets -p tcp -m multiport --dport $drop_ports -j ACCEPT; echo $?`
tunnel_rules_accept_ipv4=`sudo iptables -C mail_search -d $ip4_networks -p tcp -m multiport --dport $drop_ports -j ACCEPT; echo $?`

if [ ! $tunnel_rules_accept_ipv6 = 0 ] || [ ! $source_rules_accept_ipv6 = 0 ] || [ ! $tunnel_rules_accept_ipv4 = 0 ];
    then echo "Cannot found old rules. Try to add new rules into firewall";
    #Flush old rules
    sudo ip6tables -w -F mail_search;
    sudo iptables -w -F mail_search;
    sudo ip6tables -w -D INPUT -j mail_search;
    sudo iptables -w -D INPUT -j mail_search;

    #Prepare to add new rules
    sudo ip6tables -w -N mail_search;
    sudo iptables -w -N mail_search;
    sudo ip6tables -w -A INPUT -j mail_search;
    sudo iptables -w -A INPUT -j mail_search;

    rules_accept_added_tunnel6=`sudo ip6tables -w -A mail_search -d $ip6_networks -p tcp -m multiport --dport $drop_ports -j ACCEPT; echo $?;`
    rules_accept_added_tunnel4=`sudo iptables -w -A mail_search -d $ip4_networks -p tcp -m multiport --dport $drop_ports -j ACCEPT; echo $?;`
    rules_accept_added_source6=`sudo ip6tables -w -A mail_search -s $source_ipv6_nets -p tcp -m multiport --dport $drop_ports -j ACCEPT; echo $?`

    if [ $rules_accept_added_tunnel6 = 0 ] && [ $rules_accept_added_tunnel4 = 0 ] && [ $rules_accept_added_source6 = 0 ];
        then echo "Rules was added successfully. Add reject rules.";
        rules_reject_added6=`sudo ip6tables -A mail_search -p tcp -m multiport --dport $drop_ports -j REJECT --reject-with icmp6-adm-prohibited; echo $?;`
        rules_reject_added4=`sudo iptables -A mail_search -p tcp -m multiport --dport $drop_ports -j REJECT --reject-with icmp-admin-prohibited; echo $?;`
        echo "Rules_reject_added6 exit code:$rules_reject_added6";
        echo "Rules_reject_added4 exit code:$rules_reject_added4";
    else
        echo "Accept rules was not added to firewall. So we cant add reject rules, passing.";
    fi;
else
    echo "Old rules finded. Do nothing.";
fi;

