#!/bin/bash
source $BSCONFIG_IDIR/msearch-proxy-config.sh

drop_ports="$SERVER_IPORT,$(($SERVER_IPORT+1))";
list_of_permitted6=`for host in $(ip -6 addr show dev dummy0 | grep inet6 | tr -s " " | awk '{print $2}' | cut -d '/' -f 1);
do hosts_checked="$hosts_checked,$host";
done;

hosts_checked="$hosts_checked,::1"
echo $hosts_checked | sed 's/^,*//';`

list_of_permitted4=`for host in $(ip -4 addr show dev dummy0 | grep inet | tr -s " " | awk '{print $2}' | cut -d '/' -f 1);
do hosts_checked="$hosts_checked,$host";
done;

hosts_checked="$hosts_checked,127.0.0.1"
echo $hosts_checked | sed 's/^,*//';`

# check ipv4
rules_accept_checked6=`sudo ip6tables -C mail_search -d $list_of_permitted6 -p tcp -m multiport --dport $drop_ports -j ACCEPT; echo $?`
# check ipv4
rules_accept_checked4=`sudo iptables -C mail_search -d $list_of_permitted4 -p tcp -m multiport --dport $drop_ports -j ACCEPT; echo $?`

if [ ! $rules_accept_checked6 = 0 ] || [ ! $rules_accept_checked4 = 0 ];
    then echo "Cannot found old rules. Try to add new rules into firewall";
    #Flush old rules
    sudo ip6tables -w -F mail_search;
    sudo iptables -w -F mail_search;
    sudo ip6tables -w -D INPUT -j mail_search;
    sudo iptables -w -D INPUT -j mail_search;

    #Prepare to add new rules
    sudo ip6tables -w -N mail_search;
    sudo iptables -w -N mail_search;
    sudo ip6tables -w -A INPUT -j mail_search;
    sudo iptables -w -A INPUT -j mail_search;

    rules_accept_added6=`sudo ip6tables -w -A mail_search -d $list_of_permitted6 -p tcp -m multiport --dport $drop_ports -j ACCEPT; echo $?;`
    rules_accept_added4=`sudo iptables -w -A mail_search -d $list_of_permitted4 -p tcp -m multiport --dport $drop_ports -j ACCEPT; echo $?;`

    if [ $rules_accept_added6 = 0 ] && [ $rules_accept_added4 = 0 ];
        then echo "Rules was added successfully. Add reject rules.";
        rules_reject_added6=`sudo ip6tables -A mail_search -p tcp -m multiport --dport $drop_ports -j REJECT --reject-with icmp6-adm-prohibited; echo $?;`
        rules_reject_added4=`sudo iptables -A mail_search -p tcp -m multiport --dport $drop_ports -j REJECT --reject-with icmp-admin-prohibited; echo $?;`
        echo "Rules_reject_added6 exit code:$rules_reject_added6";
        echo "Rules_reject_added4 exit code:$rules_reject_added4";
    else
        echo "Accept rules was not added to firewall. So we cant add reject rules, passing.";
    fi;
else
    echo "Old rules finded. Do nothing.";
fi;
