#!/usr/bin/env python
# -*- coding: utf-8 -*-
# author: okkk

# Script exiting with "1" error code if cannot get searchmap from cluster management system

import argparse
import os
import urllib2
import time
import sys

CLUSTER_URL = "http://mage.n.yandex-team.ru/api/v{API_VERSION}/{PRODUCT}/getmap?revision={REVISION}&full=true{NEWFORMAT_GROUPS}"
#"http://mage.n.yandex-team.ru/api/v1.0/mail/getmap?revision={REVISION}&full=true&new_format_groups=SAS_MAIL_LUCENE,SAS_MAILFAT_LUCENE"

TRIES = 2
SLEEP = 5
OAUTH_TOKEN = ""

SEARCHMAP_PATH = "searchmap_{PRODUCT}_tmp.txt"
REVISION_FILE_PATH = "revision_{PRODUCT}.txt"

NEWFORMAT_GROUPS = ""

def make_auth_req_post(url, token=None, timeout=20):
    request = urllib2.Request(url)
    request.add_header('Content-Type', 'application/json')
    if token:
        request.add_header("Authorization", "OAuth {0}".format(token))
    attempts = 0
    while attempts < TRIES:
        try:
            result = urllib2.urlopen(request, timeout=timeout)
            break
        except Exception as e:
            attempts += 1
            print("Error reached {0} Url: {2} Retry count:{1}".format(e, attempts, url))
            time.sleep(SLEEP)
            if attempts == TRIES:
                print("Timeout!")
                raise Exception("Timeout exception!")
    return result.read()


if __name__ == "__main__":
    try:
        env = os.environ

        parser = argparse.ArgumentParser()
        parser.add_argument('-p', '--product', help='mail or mailcorp', dest='product', default=None)
        parser.add_argument('-a', '--apiversion', help='1.0 or 2.0', dest='apiversion', default="2.0")
        parser.add_argument('-n', '--new_format_groups', help='list of gencfg groups for mt like formatting', dest='new_format_groups', default=None)

        args = parser.parse_args()

        if not args.product:
            print 'Missing product argument'
            sys.exit(1)

        if args.new_format_groups:
            print 'New_format_groups argument specified. Mtn like syntax for groups: {new_format_groups}'.format(new_format_groups=args.new_format_groups)
            NEWFORMAT_GROUPS = "&new_format_groups={new_format_groups}".format(new_format_groups=args.new_format_groups)

        revision_path = REVISION_FILE_PATH.format(PRODUCT=args.product)
        with open(revision_path, 'r') as f:
            revision = f.readlines()[0].strip()

        print("Revision change reached through notify hook: {0}".format(revision))

        mage_url = CLUSTER_URL.format(BSCONFIG_IHOST=env['BSCONFIG_IHOST'],
                                      BSCONFIG_IPORT=env['BSCONFIG_IPORT'],
                                      API_VERSION=args.apiversion,
                                      PRODUCT=args.product,
                                      REVISION=revision,
                                      NEWFORMAT_GROUPS=NEWFORMAT_GROUPS)

        print("Getting map through url: {0}".format(mage_url))

        # Getting map
        answer_map = make_auth_req_post(mage_url, token=OAUTH_TOKEN, timeout=20)

        list_answer = answer_map.splitlines()
        if len(list_answer) < 50:
            print("Answer is too small. Looks like error. Getmaprev aborting! len: {0}".format(len(list_answer)))
            raise Exception("Answer is too small. Looks like error. Getmaprev aborting! len: {0}".format(len(list_answer)))

        searchmap_path = SEARCHMAP_PATH.format(PRODUCT=args.product)
        with open(searchmap_path, 'w+') as f:
            f.write(answer_map)
    except Exception as e:
        print("Cannot get latest searchmap version. Executing exception reached: {0}, exit with error".format(e))
        sys.exit(1)
