#!/bin/bash
set -xo pipefail
source recommended_java_args.sh
source mail-config-base.sh

export PS3183ATTACHSHIELD="false";
# SUBS_MIGRATION
SUBS_MIGR_PROD="2011268"
SUBS_MIGR_CORP="2011270"
SUBS_MIGR_TEST="2011266"
# nsls
NSLS_TEST="2008447"
NSLS_CORP_TEST="2008451"
NSLS_PROD="2008435"
NSLS_CORP_PROD="2008449"
# https://abc.yandex-team.ru/services/mail_frontend/resources
WEBAPI_DEVELOPMENT="2006051"
WEBAPI_CORP="2006175"
WEBAPI_PERFOM_TEST="2006191"
WEBAPI_TEST="2006177"
WEBAPI_PROD="2006171"

MOBAPI_DEVELOPMENT="2011344"
MOBAPI_TEST="2011350"
MOBAPI_INT_PROD="2011348"
MOBAPI_PROD="2011346"

MOBAPI_DEV="2011344"

MAIL_DELIVERY_PROD="2008435"
MAIL_DELIVERY_CORP="2008449"
# FURITA https://st.yandex-team.ru/PS-3477
FURITA_TVM_CORP_PROD=2016041
FURITA_TVM_PROD=2016039
FURITA_TVM_LOAD=2016045
FURITA_TVM_TESTING=2016043

#LITE https://st.yandex-team.ru/PS-3296
LITE_TVM_CORP_PROD=2012126
LITE_TVM_PROD=2012124
LITE_TVM_LOAD=2012130
LITE_TVM_TESTING=2012128

#IMAP https://st.yandex-team.ru/RTEC-2600
IMAP_TVM_PROD=2010732
IMAP_TVM_CORP_PROD=2010840
IMAP_TVM_TESTING=2010734

#ACEVENTURA_PROXY
ACEVENTURA_TVM_PROD=2014088
ACEVENTURA_TVM_TEST=2014086

#DISK CHEMODAN CHEMODAN-77753
DISK_TVM_PROD=127
DISK_TVM_TEST=2000061

#SEE ISEARCH-6016
ML_TVM_PROD=2001043
ML_TVM_TEST=2001037


#SPANIEL PS-3769
SPANIEL_TEST=2028451
SPANIEL_PROD=2028453

export SPDAEMON_TVM_ID=0

CPU_CORES_CORRECTION=${CPU_CORES_CORRECTION:-"0.2"}
if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
fi
export CPU_CORES=${CPU_CORES:-2}

case "$NANNY_SERVICE_ID" in
    *_msearch_proxy_test)
        export SERVER_IPORT="$BSCONFIG_IPORT"
        export WEBATTACH_HOST="attach-tst.mail.yandex.net"
        export CORP_WEBATTACH_HOST="attach-tst.mail.yandex.net"
        export DISK_PROXY_HOST="man2-6631-259-disksearch-proxy-d3e-21403.gencfg-c.yandex.net:21403"
        export TVM_BP_ALLOWED_SRCS="$TVM_CLIENT_ID,$WEBAPI_DEVELOPMENT,$WEBAPI_TEST,$MOBAPI_TEST,$MOBAPI_DEVELOPMENT,$LITE_TVM_TESTING,$IMAP_TVM_TESTING,$NSLS_TEST,$SUBS_MIGR_TEST,$ACEVENTURA_TVM_TEST"
        export TVM_CORP_ALLOWED_SRCS="$TVM_BP_ALLOWED_SRCS,$NSLS_CORP_TEST"
        export SPDAEMON_TVM_ID="2010396,2001437"
        export SERVICE_BALANCER_NAME=msearch-proxy-test.search.yandex.net
        export SERVICE_CONFIGNAME=msearch-proxy-test.conf
        export PS3183ATTACHSHIELD="true"
        export CORP_ML_TVM_ID="2010122"
        export TVM_ALLOWED_SUBSCRIPTIONS="$TVM_CLIENT_ID,$FURITA_TVM_TESTING,$TVM_CLIENT_ID,$WEBAPI_DEVELOPMENT,$WEBAPI_TEST,$MOBAPI_TEST,$MOBAPI_DEVELOPMENT,$LITE_TVM_TESTING,$NSLS_TEST,$SUBS_MIGR_TEST"
        export TVM_ALLOWED_ASYNC_FURITA="$TVM_CLIENT_ID,$FURITA_TVM_TESTING"
	      export TVM_ALLOWED_CHEMODAN="$TVM_CLIENT_ID,$DISK_TVM_TEST,$WEBAPI_TEST"
        export TVM_ALLOWED_ML="$TVM_CLIENT_ID,$ML_TVM_TEST"
	      export TVM_SPANIEL_ALLOWED="$TVM_CLIENT_ID,$SPANIEL_TEST"
	      export SUBSCRIPTIONS_QUEUE="change_log"
	      export TVM_ALLOWED_MULTISEARCH="$TVM_CLIENT_ID,2021181"

        ;;
    *_msearch_proxy_qa)
        export SERVER_IPORT="$BSCONFIG_IPORT"
        export WEBATTACH_HOST="retriever-qa.mail.yandex.net"
        export CORP_WEBATTACH_HOST="retriever-corp-qa.mail.yandex.net"
        #export DISK_PROXY_HOST="man1-7315-disksearch-yadisk-proxy-19502.gencfg-c.yandex.net:19502"
        export DISK_PROXY_HOST="disk-proxy-http.pers.yandex.net:80"
        export TVM_BP_ALLOWED_SRCS="$TVM_CLIENT_ID,$WEBAPI_DEVELOPMENT,$WEBAPI_PERFOM_TEST,$WEBAPI_PROD,$MOBAPI_PROD,$LITE_TVM_PROD,$IMAP_TVM_PROD,$LITE_TVM_LOAD,$MAIL_DELIVERY_PROD,$MOBAPI_DEV,$SUBS_MIGR_PROD"
        export TVM_CORP_ALLOWED_SRCS="$TVM_CLIENT_ID,$WEBAPI_DEVELOPMENT,$WEBAPI_PERFOM_TEST,$WEBAPI_CORP,$MOBAPI_INT_PROD,$LITE_TVM_CORP_PROD,$IMAP_TVM_CORP_PROD,$MAIL_DELIVERY_CORP,$SUBS_MIGR_CORP,$ACEVENTURA_TVM_TEST"
        export SERVICE_BALANCER_NAME=msearch-proxy-qa.search.yandex.net
        export SERVICE_CONFIGNAME=msearch-proxy-prod.conf
        export PS3183ATTACHSHIELD="true"
        export CORP_ML_TVM_ID="2014406"
        export MAGIC_TVM_ID="2002418"
        export TVM_ALLOWED_SUBSCRIPTIONS="$TVM_CLIENT_ID,$FURITA_TVM_LOAD,$FURITA_TVM_PROD,$FURITA_TVM_CORP_PROD,$WEBAPI_DEVELOPMENT,$WEBAPI_PERFOM_TEST,$WEBAPI_PROD,$MOBAPI_PROD,$LITE_TVM_LOAD,$MAIL_DELIVERY_PROD,$MOBAPI_DEV,$SUBS_MIGR_PROD,$MAGIC_TVM_ID,$WEBAPI_CORP,$MOBAPI_INT_PROD"
        export TVM_ALLOWED_ASYNC_FURITA="$TVM_CLIENT_ID,$FURITA_TVM_LOAD,$FURITA_TVM_PROD"
        export TVM_ALLOWED_CORP_ASYNC_FURITA="$TVM_CLIENT_ID,$FURITA_TVM_CORP_PROD"
        export TVM_ALLOWED_CHEMODAN="$TVM_CLIENT_ID,$DISK_TVM_TEST,$WEBAPI_PROD"
        export TVM_ALLOWED_ML="$TVM_CLIENT_ID,$ML_TVM_TEST"
        export TVM_SPANIEL_ALLOWED="$TVM_CLIENT_ID,$SPANIEL_PROD"
        export TVM_ALLOWED_MULTISEARCH="$TVM_CLIENT_ID,2021183"
	;;
    *_msearch_proxy|*_msearch_proxy_yp)
        export SERVER_IPORT="8051"
        export WEBATTACH_HOST="webattach.mail.yandex.net"
        export CORP_WEBATTACH_HOST="webattachcorp.mail.yandex.net"
        #export DISK_PROXY_HOST="man1-7315-disksearch-yadisk-proxy-19502.gencfg-c.yandex.net:19502"
        export DISK_PROXY_HOST="disk-proxy-http.pers.yandex.net:80"
        export TVM_BP_ALLOWED_SRCS="$TVM_CLIENT_ID,$WEBAPI_DEVELOPMENT,$WEBAPI_PROD,$MOBAPI_PROD,$LITE_TVM_PROD,$IMAP_TVM_PROD,$SUBS_MIGR_PROD,$ACEVENTURA_TVM_PROD"
        export TVM_CORP_ALLOWED_SRCS="$TVM_CLIENT_ID,$WEBAPI_DEVELOPMENT,$WEBAPI_CORP,$MOBAPI_INT_PROD,$LITE_TVM_CORP_PROD,$IMAP_TVM_CORP_PROD,$SUBS_MIGR_CORP"
        export SERVICE_BALANCER_NAME=new-msearch-proxy.mail.yandex.net
        export SERVICE_CONFIGNAME=msearch-proxy-prod.conf
        export PS3183ATTACHSHIELD="true"
        export CORP_ML_TVM_ID="2014406"
        export TVM_ALLOWED_SUBSCRIPTIONS="$TVM_CLIENT_ID,$FURITA_TVM_PROD,$FURITA_TVM_CORP_PROD,$WEBAPI_DEVELOPMENT,$WEBAPI_PROD,$MOBAPI_PROD,$LITE_TVM_PROD,$SUBS_MIGR_PROD,$WEBAPI_CORP,$MOBAPI_INT_PROD"
        export TVM_ALLOWED_ASYNC_FURITA="$TVM_CLIENT_ID,$FURITA_TVM_PROD"
        export TVM_ALLOWED_CORP_ASYNC_FURITA="$TVM_CLIENT_ID,$FURITA_TVM_CORP_PROD"
	      export TVM_ALLOWED_CHEMODAN="$TVM_CLIENT_ID,$DISK_TVM_PROD,$WEBAPI_PROD"
        export TVM_ALLOWED_ML="$TVM_CLIENT_ID,$ML_TVM_PROD"
        export TVM_SPANIEL_ALLOWED="$TVM_CLIENT_ID,$SPANIEL_PROD"
        export TVM_ALLOWED_MULTISEARCH="$TVM_CLIENT_ID,2021183"
        ;;
    *_sosearch_proxy_*)
        export SERVER_IPORT="$BSCONFIG_IPORT"
        export TVM_BP_ALLOWED_SRCS="$TVM_CLIENT_ID,$WEBAPI_DEVELOPMENT,$WEBAPI_PROD,$MOBAPI_PROD,$LITE_TVM_PROD,$IMAP_TVM_PROD"
        export TVM_CORP_ALLOWED_SRCS="$TVM_CLIENT_ID,$WEBAPI_DEVELOPMENT,$WEBAPI_CORP,$MOBAPI_INT_PROD,$LITE_TVM_CORP_PROD,$IMAP_TVM_CORP_PROD"
        export SERVICE_BALANCER_NAME=sosearch-proxy.mail.yandex.net
        export SERVICE_CONFIGNAME=sosearch-proxy-prod.conf
        export CORP_ML_TVM_ID="2014406"
        export MSEARCH_PROXY_ADDITIONAL_ARGS="-DPORTO=1 -XX:ActiveProcessorCount=$CPU_CORES"
        export MEMORY_GAP=$((1024*1024*1024))
        ;;
esac

