#!/bin/bash
set -exo pipefail

source $BSCONFIG_IDIR/msearch-proxy-config.sh
source classpath.sh

memgap=${MEMORY_GAP:-0}

if [ "$MEM_LIMIT" != "" ]
then
    MEMORY_LIMIT=$(((MEM_LIMIT - memgap) * 80 / 100))
else
    MEMORY_LIMIT=$(($(cat dump.json | grep "memory_guarantee" | head | tr -d '":,\t' | awk '{print int($2*0.8)}') - memgap))
fi

jmxport=$(echo $(($SERVER_IPORT+2)))

echo "Msearch proxy balancer $SERVICE_BALANCER_NAME"

CORE_DIR="/coredumps"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
APP_ARGS="-DBSCONFIG_IPORT=$SERVER_IPORT
-DBSCONFIG_IHOST=$BSCONFIG_IHOST
-DBSCONFIG_INAME=$BSCONFIG_INAME
-DBSCONFIG_IDIR=$BSCONFIG_IDIR
-DTVM_API_HOST=https://tvm-api.yandex.net
-DTVM_CLIENT_ID=$TVM_CLIENT_ID
-DBLACKBOX_CLIENT_ID=$BLACKBOX_CLIENT_ID
-DCORP_BLACKBOX_CLIENT_ID=$CORP_BLACKBOX_CLIENT_ID
-DSERVER_NAME=$SERVICE_BALANCER_NAME"

COMMON_ARGS="-Dcom.sun.management.jmxremote
-Dcom.sun.management.jmxremote.ssl=false
-Dcom.sun.management.jmxremote.authenticate=false
-Dcom.sun.management.jmxremote.port=$jmxport
-Dorg.apache.commons.logging.Log=org.apache.commons.logging.impl.SimpleLog
-Dorg.apache.commons.logging.simplelog.showdatetime=false
-Dorg.apache.commons.logging.simplelog.log.org.apache.http=OFF
-Dorg.apache.commons.logging.simplelog.log.org.apache.http.wire=OFF
-Djava.rmi.server.hostname=$BSCONFIG_IHOST
-Djava.library.path=$BSCONFIG_IDIR"

if jdk/bin/java -version 2>&1 | fgrep -q -e OpenJ9 -e Ibm -e IBM
then
    GC_ARGS="
    -Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact
    -verbose:gc
    -Xgcpolicy:gencon
    -Xmn1G
    -Xverbosegclog:/dev/shm/gclogs/$SERVER_IPORT-gc#.log,10,10000
    -Xmx$MEMORY_LIMIT
    -Xms$MEMORY_LIMIT
    "
else
    GC_ARGS="
    -XX:ActiveProcessorCount=$CPU_CORES
    -XX:+IgnoreUnrecognizedVMOptions
    -XX:+HeapDumpOnOutOfMemoryError
    -XX:HeapDumpPath=/coredumps
    -XcompilationThreads1
    -Xmx$MEMORY_LIMIT
    -Xms$MEMORY_LIMIT
    -XX:+PrintGC
    -XX:+PrintGCDetails
    -XX:+UnlockExperimentalVMOptions
    -verbose:gc
    -XX:+UseShenandoahGC
    -XX:ConcGCThreads=2
    -XX:ShenandoahGCMode=iu
    -XX:-ShenandoahAlwaysClearSoftRefs
    -XX:ShenandoahAllocationThreshold=5
    -XX:ShenandoahUncommitDelay=100000
    -XX:ShenandoahGuaranteedGCInterval=100000
    -XX:ShenandoahGarbageThreshold=10
    -XX:SoftRefLRUPolicyMSPerMB=1000
    -XX:+PrintCodeCache
    -XX:ParallelGCThreads=$CPU_CORES
    -XX:+UnlockDiagnosticVMOptions
    -XX:+PrintGCDateStamps
    -XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=2M
    -Xlog:gc*:/dev/shm/gclogs/gc.log
    "
fi

export LD_LIBRARY_PATH=$BSCONFIG_IDIR:$BSCONFIG_IDIR/msearch_proxy_service

exec $BSCONFIG_IDIR/jdk/bin/java \
    $APP_ARGS $COMMON_ARGS $GC_ARGS $NET_ARGS $MSEARCH_PROXY_ADDITIONAL_ARGS \
    -Djava.library.path=.:msearch_proxy_service \
    -cp $CLASSPATH \
    ru.yandex.msearch.proxy.Proxy \
    -config $BSCONFIG_IDIR/$SERVICE_CONFIGNAME
