package ru.yandex.msearch;

import ru.yandex.dispatcher.consumer.ConsumerServer;
import ru.yandex.http.util.server.DefaultHttpServerFactory;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.ljinx.Ljinx;
import ru.yandex.peach.Peach;
import ru.yandex.search.mail.kamaji.Kamaji;
import ru.yandex.stater.PrefixingStater;

public final class Perseus {
    private static final String CONFIG = "-config";

    private Perseus() {
    }

    public static void main(final String[] args) {
        if (args.length < 5) {
            System.out.println(
                "Usage: ru.yandex.msearch.Perseus "
                + "consumer.conf kamaji.conf lucene.conf peach.conf "
                + "ljinx.conf");
            System.exit(-1);
        }
        final String consumerConfig = args[0];
        final String kamajiConfig = args[1];
        final String luceneConfig = args[2];
        final String peachConfig = args[3];
        final String ljinxConfig = args[4];

        Thread consumer = new Thread("consumer-main") {
            @Override
            public void run() {
                try {
                    ConsumerServer.main(CONFIG, consumerConfig);
                } catch (Exception e) {
                    System.err.println("consumer failed to start");
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        };
        consumer.start();

        Thread kamaji = new Thread("kamaji-main") {
            @Override
            public void run() {
                HttpServer<?, ?> ljinx;
                try {
                    ljinx = Ljinx.main(
                        new DefaultHttpServerFactory<>(Ljinx.class),
                        ljinxConfig);
                } catch (Exception e) {
                    System.err.println("ljinx failed to start");
                    e.printStackTrace();
                    System.exit(-1);
                    return;
                }
                try {
                    Kamaji.main(
                        new DefaultHttpServerFactory<>(Kamaji.class),
                        kamajiConfig)
                        .registerStater(
                            new PrefixingStater("ljinx-", ljinx));
                } catch (Exception e) {
                    System.err.println("kamaji failed to start");
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        };
        kamaji.start();

        Thread lucene = new Thread("lucene-main") {
            @Override
            public void run() {
                try {
                    Daemon.main(CONFIG, luceneConfig);
                } catch (Exception e) {
                    System.err.println("lucene failed to start");
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        };
        lucene.start();

        Thread peach = new Thread("peach-main") {
            @Override
            public void run() {
                try {
                    Peach.main(
                        new DefaultHttpServerFactory<>(Peach.class),
                        peachConfig);
                } catch (Exception e) {
                    System.err.println("peach failed to start");
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        };
        peach.start();
    }
}

