#!/bin/sh

GB=$((1024*1024*1024))
GB1_5=$((GB + (GB/2)))
GB2=$((GB + GB))
GB3=$((GB + GB + GB))
XMX=$(portoctl get . memory_limit_total)

#more memory due to PS-3771
XMX=$((XMX-GB3))

# there no ssd cache anymore, delete later
#if [ -d /ssd ]; then
#	#extra 512M for Sqlite native cache
#	XMX=$((XMX-GB2))
#else
#	XMX=$((XMX-GB1_5))
#fi

mkdir -p /webcache/javasharedresources/512m >/dev/null 2>&1
export GC_ARGS="-XX:ActiveProcessorCount=3 \
-XX:+IgnoreUnrecognizedVMOptions \
-XcompilationThreads1 \
-Xgc:concurrentScavengeBackground=1 \
-Xgc:concurrentScavenge \
-XX:IdleTuningGcOnIdle \
-XX:IdleTuningMinIdleWaitTime=1 \
-Xgc:maxScavengeBeforeGlobal=100 \
-Xcodecache8M \
-Xcodecachetotal64M \
-Xmso128K \
-Xmcrs64M \
-Xmx$XMX \
-Xms$XMX \
-Xmn512M \
-Xgcthreads2 \
-Xconcurrentbackground1 \
-Xgc:concurrentMark \
-Xaggressive \
-Xsoftrefthreshold1000000000 \
-Xjit:scratchSpaceLimit=$((64*1024)) \
-Djdk.nio.maxCachedBufferSize=$((256*1024)) \
-verbose:gc \
-Xverbosegclog:/dev/shm/gc.log,10,10000 \
-Xtune:virtualized"
