#!/bin/bash
set -exo pipefail
source mail-config-base.sh

export SEARCH_PORT=$((BSCONFIG_IPORT + 1))
export INDEXER_PORT=$((BSCONFIG_IPORT + 2))
export CONSUMER_PORT=$((BSCONFIG_IPORT + 3))

export REPLICA_NAME=$(jq .leader.dynamicProperties.GENCFG_GROUP metainstance.json|tr -d '"'|tr 'A-Z_' 'a-z-')
export LJINX_PORT=$((BSCONFIG_IPORT+5))
export SEARCH_BACKEND_SECTION="lucene"
#export MTN_TAG=$(hostname -s)
export LUCENE_FIELDS_CONFIG_DIR=$BSCONFIG_IDIR
export LUCENE_CONFIG_SSD="$BSCONFIG_IDIR/perseus-nossd.conf"

export MTN_TAG=$(echo $HOSTNAME | cut -d '.' -f 1-2)
export INUM=$(cat inum.txt || echo False)

>&2 echo "Current inum is: $INUM"

if [ "$INUM" = "False" ]
then
   >&2 echo "$(date) inum.txt does not exists. Exiting. Inum is: $INUM"
   exit 1
fi

case "$NANNY_SERVICE_ID" in
    mailcorp_*) 
        export LIMIT_THREADS="False"
        export COPIER_THREADS=5
        export COPIER_MAXRATE=40
        export INDEX_BASE="/webcache/mtsearch"
        export CORP=1
        export CONF_DIR="$BSCONFIG_IDIR/corp"
        export LOGROTATE_DAYS=1
        export KAMAJI_LOGROTATE_DAYS=5
        export LUCENE_CONFIG_INCLUDE="$CONF_DIR/search_backend_thin.conf"
        ;;
    *)
        export SHARDING_FIELDS="__prefix,suid,abook_suid,uid,fact_uid"
        
        export CONF_DIR="bp"
        export LUCENE_SSD_CACHE_SIZE=$(df -B $((1024*1024*1024)) /ssd/ | grep /ssd | awk '{print int($2*0.95)}')

        # config optimized for ssd
        export LUCENE_CONFIG_INCLUDE="search_backend_thin_ssd.conf"
#        # no cache
        # index base on /ssd
        export INDEX_BASE="/ssd/msearch"


        export PROXY="http://ps-cache.mail.yandex.net:80"
        ;;
esac

export INDEX_DIR="$INDEX_BASE/$INUM"

