#!/bin/sh
XMX=95G
XMS=95G

mkdir -p /webcache/javasharedresources/512m >/dev/null 2>&1

export GC_ARGS="
-XX:ActiveProcessorCount=13
-XcompilationThreads1 \
-Xgcpolicy:gencon \
-Xgc:concurrentScavengeBackground=1 \
-Xgc:concurrentScavenge \
-XX:IdleTuningGcOnIdle \
-XX:IdleTuningMinIdleWaitTime=1 \
-Xgc:maxScavengeBeforeGlobal=100 \
-Xcodecache8M \
-Xcodecachetotal64M \
-Xmso128K \
-Xmcrs64M \
-Xmn12G \
-Xmx$XMX \
-Xms$XMS \
-Xgcthreads13 \
-Xconcurrentbackground5 \
-Xgc:concurrentMark \
-Xaggressive \
-Xsoftrefthreshold1000000000 \
-Xjit:scratchSpaceLimit=$((64*1024)) \
-Djdk.nio.maxCachedBufferSize=$((256*1024)) \
-verbose:gc \
-Xverbosegclog:/dev/shm/gc.log,10,10000 \
-Xtune:virtualized"
