#!/bin/bash
set -x;

if [ "$LABELS_deploy_engine" = "YP_LITE" ]
then
 echo "Disabling manual firewall in YP"
 exit 0
fi

drop_ports="$BSCONFIG_IPORT,$((BSCONFIG_IPORT+1)),8080";

macros_networks="false"

tunnel_names=`ip -6 tunnel show | cut -d":" -f1 | tr '\n' ' ' | sed "s/\ i/,i/g"`

for macros in $(cat ./gencfg_macros.txt| grep -v "#\|^$"); do
 echo "Permitted macros is: $macros";
 hbf_nets=$(curl -sf "http://hbf.yandex.net/macros/$macros?trypo_format=dottedquad&format=text")

 if [ $? != "0" ]; then
    echo "Error when try to get macros networks through hbf api"
    exit 1;
 fi;

 for net in $hbf_nets; do
  echo $net;
  echo $macros_networks
  if [ $macros_networks = "false" ]; then
   macros_networks="$net";
  else
   macros_networks="$macros_networks,$net";
  fi;
 done;
done;

# permit hosts
hosts_permit6=`for host in $(cat ./hosts_permit.txt| cut -d',' -f1 | grep -v "#\|^$");
 do dig_out=$(dig $host AAAA +short);
 if [ "$dig_out" = "" ];
 then continue;
 else hosts_checked="$hosts_checked,$host";
 fi;
 done;
 hosts_checked="$hosts_checked,::1";
 echo $hosts_checked | sed 's/^,*//';`

macros_networks="$macros_networks,$hosts_permit6"

#Do not look to the eyes of stranger. Possbile DDOS to OOPS here!  vlan 688 traffic here, see RTCSUPPORT-583
#vlan688_nets=$(curl -s https://oops.yandex-team.ru/api/hosts/$PORTO_HOST/attributes/net_info | jq -r '.interfaces[] | select(.name == "vlan688") | .ips[]' | cut -d "/" -f 1)
#if [ $? != "0" ]; then
#    echo "Error when try to vlan688 addreses through oops api"
#    exit 1;
#fi;

# Another hardcore solution see https://st.yandex-team.ru/RUNTIMECLOUD-5930
vlan688_nets=$(ip -6 a show scope global | grep "inet6" | tr -s " "  | cut -d " " -f "3" | cut -d "/" -f "1" | while read ipad; do sipcalc -a -6 $ipad/64 | grep "Subnet prefix (masked)" | tr "\t" " " | cut -d " " -f "5";done;)

for vlan688_net in $vlan688_nets;do
    macros_networks="$macros_networks,$vlan688_net";
done;

for vlan688_net in $vlan688_nets;do
 macros_networks="$macros_networks,$vlan688_net";
done;

# permit balancer ip traffic
for tun in $(ip -6 tunnel show | cut -d":" -f1); do
 for tun_addr in $(ip -6 addr show dev $tun | grep inet6 |tr -s " " | awk '{print $2}' | cut -d '/' -f 1); do
  macros_networks="$macros_networks,$tun_addr";
 done;
done;

# check ipv4 ?
rules_accept_checked=`sudo ip6tables -C mail_search -s $macros_networks -p tcp -m multiport --dport $drop_ports -j ACCEPT; echo $?`
tunnel_rules_checked="1";
if [ $rules_accept_checked = 0 ]; then
 tunnel_rules_checked=`sudo ip6tables -C mail_search -i $tunnel_names -p tcp -m multiport --dport $drop_ports -j ACCEPT; echo $?;`
fi;

if [ ! $tunnel_rules_checked = 0 ];
    then echo "Cannot found old rules. Try to add new rules into firewall";
    #Flush old rules
    sudo ip6tables -w -F mail_search;
    sudo ip6tables -w -D INPUT -j mail_search;
    sudo iptables -w -F mail_search;
    sudo iptables -w -D INPUT -j mail_search;

    #Prepare to add new rules
    sudo ip6tables -w -N mail_search;
    sudo ip6tables -w -A INPUT -j mail_search;
    sudo iptables -w -N mail_search;
    sudo iptables -w -A INPUT -j mail_search;

    #Permit localhost ()
    #sudo ip6tables -w -A mail_search -s ::1/128 -p tcp -m multiport --dports $drop_ports  -j ACCEPT;
    macros_networks="$macros_networks,::1"

    rules_accept_added=`sudo ip6tables -w -A mail_search -s $macros_networks -p tcp -m multiport --dport $drop_ports -j ACCEPT; echo $?;`

    # permit traffic to tunnel interface
    tunnel_rules_accept_added="1";
    if [ $rules_accept_added = 0 ]; then
        tunnel_rules_accept_added=`sudo ip6tables -w -A mail_search -i $tunnel_names -p tcp -m multiport --dport $drop_ports -j ACCEPT; echo $?;`
    fi;

    if [ $tunnel_rules_accept_added = 0 ];
        then echo "Rules was added successfully. Add reject rules.";
        rules_reject_added6=`sudo ip6tables -A mail_search -p tcp -m multiport --dport $drop_ports -j REJECT --reject-with icmp6-adm-prohibited; echo $?;`

        # reject all ipv4 traffic here
        rules_reject_added4=`sudo iptables -A mail_search -p tcp -m multiport --dport $drop_ports -j REJECT --reject-with icmp-admin-prohibited; echo $?;`
        echo "Rules_reject_added6 exit code:$rules_reject_added6";
        echo "Rules_reject_added4 exit code:$rules_reject_added4";
    else
        echo "Accept rules was not added to firewall. So we cant add reject rules, passing.";
        exit 1
    fi;
else
    echo "Old rules finded. Do nothing.";
fi;

