#! /usr/bin/perl

use strict;
use warnings;

use constant MONTH_TO_NUM => {
    'Jan' => '01',
    'Feb' => '02',
    'Mar' => '03',
    'Apr' => '04',
    'May' => '05',
    'Jun' => '06',
    'Jul' => '07',
    'Aug' => '08',
    'Sep' => '09',
    'Oct' => '10',
    'Nov' => '11',
    'Dec' => '12'
};
my $date_regex = '(\d\d)/('.join('|', keys %{MONTH_TO_NUM()}).')\/(\d\d\d\d):(\d\d:\d\d:\d\d)';

while(<STDIN>) {
    chomp;
    my ($pos, $line);
    if(/^(\d+;\d+;\d+;)(.+)$/o) {
        ($pos, $line) = ($1, $2);
    } else {
        ($pos, $line) = ("", $_);
    }
# 127.0.0.1 - - [13/May/2015:20:02:03 +0300] "GET /?db=mdb300&text=test&format=json&getfields=mid%2Creceived_date&user=12054080 HTTP/1.1" 200 - 661 2b3bede51edf1800 - "-" 920
# 127.0.0.1 - - [13/May/2015:20:02:03 +0300] "GET /?db=mdb300&text=test&format=json&getfields=mid%2Creceived_date&user=12054080 HTTP/1.1" 200 - 661 2b3bede51edf1800 D3M2MC "/api/async/mail/search?request=etst&mdb=mdb300&suid=12054080&per_page=10&hr&message_type=4" 920
    next unless $line =~ /^([^\s]+)\s-\s-\s\[$date_regex\s([\+-]\d+)\]\s"([^\s]+)\s([^\s]+)\s([^"]+)"\s(\d+)\s(\d+|-)\s(\d+)\s(\w+)\s(\w+|-)\s"([^"]+)"\s?(\d*)/o;
    my ($ip, $day, $month, $year, $timestamp, $timezone, $method, $request, $protocol, $status, $response_size, $processing_millitime, $session_id, $proxy_session_id, $referer, $docs_count) = ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16);
    $docs_count = $docs_count || 0;
    $month = MONTH_TO_NUM()->{$month};

    print $pos, "tskv\ttskv_format=access-log-msearch\tvhost=lucene.mail.yandex.net\tip=$ip\ttimestamp=$year-$month-$day $timestamp\ttimezone=$timezone\tmethod=$method"
            ."\trequest=$request\tprotocol=$protocol\tstatus=$status\tresponse_size=$response_size\tprocessing_millitime=$processing_millitime"
            ."\tsession_id=$session_id\tproxy_session_id=$proxy_session_id\treferer=$referer\tdocs_count=$docs_count\n";
}
