#!/bin/bash
set -exo pipefail
source config.sh
source classpath.sh

./check_its_status.py || exit 1

# validate SEARCH_BACKEND_SECTION
egrep "\[[a-zA-Z_\-]+\]" ./instancectl.conf | grep -q "\[$SEARCH_BACKEND_SECTION\]" || exit 1

portoctl run self/low command= isolate=false controllers[cpu]=true cpu_limit=1c cpu_period=10ms || true
portoctl run self/scripts command= isolate=false controllers[cpu]=true cpu_limit=0.3c || true

APP_ARGS="-DBSCONFIG_IPORT=$BSCONFIG_IPORT
-DBSCONFIG_IHOST=$BSCONFIG_IHOST
-DBSCONFIG_INAME=$BSCONFIG_INAME
-DMTN_TAG=$MTN_TAG
-DREPLICA_NAME=$REPLICA_NAME
-DINUM=$INUM
-DLUCENE_CONFIG_INCLUDE=$LUCENE_CONFIG_INCLUDE
-DLUCENE_CONFIG_SSD=$LUCENE_CONFIG_SSD
"

CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
export LD_LIBRARY_PATH=$BSCONFIG_IDIR:$BSCONFIG_IDIR/perseus
export LD_PRELOAD=/usr/lib/libtcmalloc_minimal.so.4:$BSCONFIG_IDIR/libldpreload.so

source $CONF_DIR/gc_args.sh

PERSEUS_CONFIGS="\
$CONF_DIR/consumer.conf \
$CONF_DIR/kamaji.conf \
$CONF_DIR/search_backend.conf \
$CONF_DIR/peach.conf \
$CONF_DIR/ljinx.conf"

exec $BSCONFIG_IDIR/jdk/bin/java \
    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
    -Djava.library.path=.:perseus \
    -verbose:gc \
    $NET_ARGS $GC_ARGS $APP_ARGS \
    -DPORTO=1 \
    -cp $CLASSPATH \
    ru.yandex.msearch.Perseus \
    $PERSEUS_CONFIGS
