#!/bin/bash
set -exo pipefail

source config.sh

STATUS_PORTS=(
# consumer
$CONSUMER_PORT
# peach
$((BSCONFIG_IPORT + 7))
# kamaji
$((BSCONFIG_IPORT + 4))
# ljinx
$LJINX_PORT
)

PING_PORTS=(
$SEARCH_PORT
$INDEXER_PORT
$CONSUMER_PORT
$((BSCONFIG_IPORT + 4))
$((BSCONFIG_IPORT + 7))
$LJINX_PORT
)

source check_search_backend_copyness_status.sh

end_date=$(expr $(date +%s) + 3600)
while true
do
    if [ $(date +%s) -ge $end_date ]
    then
        echo "$(date) Status script timed out"
        exit 1
    fi

    echo "$(date) Ping and clients check" 

    # Fast check clients, if any client is in any state except ACTIVE, exit 1
    # If /status is not available, probably service is not started yet,
    # just skip this check
    for status_port in ${STATUS_PORTS[@]}
    do
        if ! FAIL_FAST_EXIT_CODE=0 PORT=$status_port REQUEST_TIMEOUT=30 timeout 60 ./check_clients_status.sh
        then
            echo "$(date) Port $status_port /status check failed"
            exit 1
        fi
    done

    # Fast check, just sleep on failure
    failed=0
    for ping_port in ${PING_PORTS[@]}
    do
        if ! PORT=$ping_port REQUEST_TIMEOUT=30 timeout 60 ./check_http_status.sh
        then
            echo "$(date) Port $ping_port /ping check failed"
            failed=1
            break
        fi
    done

    if [ $failed -eq 1 ]
    then
        sleep 1
        continue
    fi

    ## Index checks are disabled by default because they didn't work as expected - on any network issues lucene will be restarted  
   
    # New index checks
    #echo "$(date) indexation check" 
    #WATCHDOG_VERSION=$(date +%s)000000
    #code=$(curl -sm 60 -o /dev/stderr -w '%{http_code}' --data-binary '{"operation_id":0,"uid":203889311,"lcn":1,"change_type":"store","operation_date":0,"changed":[{"mid":156218612074414099}]}' 'localhost:'$((BSCONFIG_IPORT+4))'/notify?mdb=pg&uid=203889311&pinger')
    #if [ $code != 200 ]
    #then
    #    echo "$(date) Indexation failed"
    #    sleep 1
    #    continue
    #fi

    # Old index checks
    #code=$({curl -sm 60 -o /dev/stderr -w '%{http_code}' --data-binary '{"operation_id":0,"uid":203889311,"lcn":1,"change_type":"store","operation_date":0,"changed":[{"mid":156218612074414099}]}' 'localhost:'$((BSCONFIG_IPORT+4))'/notify?mdb=pg&pinger' 3>&2 2>&1 1>&3 | grep -om1 UnknownHostException | tr -d '\n'} 2>&1)
    #if [ "$code" != "000" -a "$code" != "529" -a "$code" != "502UnknownHostException" ]
    #then
    #    echo "$(date) indexation check success"
    #else
    #    echo "$(date) indexation check failed"
    #    continue
    #fi

    break
done
exit 0

