#!/bin/bash
set -exo pipefail

source mail-config-base.sh

SEARCHMAP_PATH_TEMP=$SEARCHMAP_PATH.tmp
rm -f $SEARCHMAP_PATH_TEMP

case "$NANNY_SERVICE_ID" in
    mailcorp_search_yp_prod)
	# echo $LABELS_shard_id > inum.txt.tmp
	# Emulate searchmap download - in yp mailcorp we have static searchmap
	cp $SEARCHMAP_PATH $SEARCHMAP_PATH_TEMP
        ;;
    mail-search-backend-prod|mail_search_yp_test|mail-search-backend-fat-prod|mail-search-backend-bckp-prod)
	# For mail-search-prod - download searchmap from mop.
        chmod +x ./get-searchmap.sh
        ./get-searchmap.sh $SEARCHMAP_PATH_TEMP
        ;;    
    mailcorp_search_prestable|mailcorp_search_prod)
        export MAGE_URI=$CORP_MAGE_URI
	SEARCHMAP_PATH=$SEARCHMAP_PATH_TEMP ./getmap-rev.py
        ;;
    mail_*)
        #export MAGE_URI=$BP_MAGE_URI
	#SEARCHMAP_PATH=$SEARCHMAP_PATH_TEMP ./getmap-rev.py
        chmod +x ./get-full-searchmap.sh
        ./get-full-searchmap.sh $MOP_PROD_SCOPE $MOP_HOST $SEARCHMAP_PATH_TEMP
        ;;
esac

if [ ! -f $SEARCHMAP_PATH_TEMP ]; then
    >&2 echo "Temp searchmap was not founded on path $SEARCHMAP_PATH_TEMP. Exiting!"
    exit 1
fi

touch inum.txt.tmp 
fgrep $HOSTNAME $SEARCHMAP_PATH_TEMP | grep -o 'iNum:[0-9]\+' | sort -u > inum.txt.tmp
inum_count=$(wc -l < inum.txt.tmp)
if [ $inum_count -ne 1 ]
then
    >&2 echo "Bad inum.txt:"
    >&2 echo "----BEGIN----"
    cat inum.txt.tmp >&2
    >&2 echo "-----END-----"
    exit 1
fi

fgrep $HOSTNAME $SEARCHMAP_PATH_TEMP | grep -o 'shards:[0-9]\+-[0-9]\+' | sort -u > shards.txt.tmp

mv -f $SEARCHMAP_PATH_TEMP $SEARCHMAP_PATH
mv -f inum.txt.tmp inum.txt
mv -f shards.txt.tmp shards.txt

