package ru.yandex.search.mail.indexer.pg;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeIntegerValidator;
import ru.yandex.parser.string.PositiveIntegerValidator;

public abstract class AbstractPgIndexerConfigBuilder
    <T extends AbstractPgIndexerConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements PgIndexerConfig
{
    private HttpHostConfigBuilder msalConfig;
    private HttpHostConfigBuilder producerConfig;
    private String serviceName;
    private int midsPerRequest;
    private int producerBatchSize;
    private int midsRetrievalRetries;

    protected AbstractPgIndexerConfigBuilder(final PgIndexerConfig config) {
        super(config);
        msalConfig = new HttpHostConfigBuilder(config.msalConfig());
        producerConfig = new HttpHostConfigBuilder(config.producerConfig());
        serviceName = config.serviceName();
        midsPerRequest = config.midsPerRequest();
        producerBatchSize = config.producerBatchSize();
        midsRetrievalRetries = config.midsRetrievalRetries();
    }

    protected AbstractPgIndexerConfigBuilder(
        final IniConfig config,
        final PgIndexerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        msalConfig = new HttpHostConfigBuilder(
            config.section("msal"),
            defaults.msalConfig());
        producerConfig = new HttpHostConfigBuilder(
            config.section("producer"),
            defaults.producerConfig());
        IniConfig pgIndexer = config.section("pg-indexer");
        serviceName = pgIndexer.get(
            "service-name",
            defaults.serviceName(),
            NonEmptyValidator.INSTANCE);
        midsPerRequest = pgIndexer.get(
            "mids-per-request",
            defaults.midsPerRequest(),
            PositiveIntegerValidator.INSTANCE);
        producerBatchSize = pgIndexer.get(
            "producer-batch-size",
            defaults.producerBatchSize(),
            PositiveIntegerValidator.INSTANCE);
        midsRetrievalRetries = pgIndexer.get(
            "mids-retrieval-retries",
            defaults.midsRetrievalRetries(),
            NonNegativeIntegerValidator.INSTANCE);
    }

    @Override
    public HttpHostConfigBuilder msalConfig() {
        return msalConfig;
    }

    public T msalConfig(final HttpHostConfig msalConfig) {
        this.msalConfig = new HttpHostConfigBuilder(msalConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder producerConfig() {
        return producerConfig;
    }

    public T producerConfig(final HttpHostConfig producerConfig) {
        this.producerConfig = new HttpHostConfigBuilder(producerConfig);
        return self();
    }

    @Override
    public String serviceName() {
        return serviceName;
    }

    public T serviceName(final String serviceName) {
        this.serviceName = serviceName;
        return self();
    }

    @Override
    public int midsPerRequest() {
        return midsPerRequest;
    }

    public T midsPerRequest(final int midsPerRequest) {
        this.midsPerRequest = midsPerRequest;
        return self();
    }

    @Override
    public int producerBatchSize() {
        return producerBatchSize;
    }

    public T producerBatchSize(final int producerBatchSize) {
        this.producerBatchSize = producerBatchSize;
        return self();
    }

    @Override
    public int midsRetrievalRetries() {
        return midsRetrievalRetries;
    }

    public T midsRetrievalRetries(final int midsRetrievalRetries) {
        this.midsRetrievalRetries = midsRetrievalRetries;
        return self();
    }
}

