package ru.yandex.search.mail.indexer.pg;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutablePgIndexerConfig
    extends ImmutableHttpProxyConfig
    implements PgIndexerConfig
{
    private final ImmutableHttpHostConfig msalConfig;
    private final ImmutableHttpHostConfig producerConfig;
    private final String serviceName;
    private final int midsPerRequest;
    private final int producerBatchSize;
    private final int midsRetrievalRetries;

    public ImmutablePgIndexerConfig(final PgIndexerConfig config)
        throws ConfigException
    {
        super(config);
        msalConfig = new ImmutableHttpHostConfig(config.msalConfig());
        producerConfig = new ImmutableHttpHostConfig(config.producerConfig());
        serviceName = config.serviceName();
        midsPerRequest = config.midsPerRequest();
        producerBatchSize = config.producerBatchSize();
        midsRetrievalRetries = config.midsRetrievalRetries();

        if (serviceName == null || serviceName.isEmpty()) {
            throw new ConfigException("service-name is not set");
        }
        if (midsPerRequest <= 0) {
            throw new ConfigException(
                "mids-per-requests expected to be positive value");
        }
        if (producerBatchSize <= 0) {
            throw new ConfigException(
                "producer-batch-size expected to be positive value");
        }
        if (midsRetrievalRetries < 0) {
            throw new ConfigException(
                "mids-retrieval-retries expected to be positive value");
        }
    }

    @Override
    public ImmutableHttpHostConfig msalConfig() {
        return msalConfig;
    }

    @Override
    public ImmutableHttpHostConfig producerConfig() {
        return producerConfig;
    }

    @Override
    public String serviceName() {
        return serviceName;
    }

    @Override
    public int midsPerRequest() {
        return midsPerRequest;
    }

    @Override
    public int producerBatchSize() {
        return producerBatchSize;
    }

    @Override
    public int midsRetrievalRetries() {
        return midsRetrievalRetries;
    }
}

