package ru.yandex.search.mail.indexer.pg;

import java.util.List;

import ru.yandex.collection.ChunkedLongList;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.PathComponent;
import ru.yandex.json.xpath.PrimitiveHandler;
import ru.yandex.json.xpath.ValueUtils;

public class Mids extends ChunkedLongList implements PrimitiveHandler {
    private static final int INITIAL_MIDS_CAPACITY = 1048576;
    private static final int CHUNK_SIZE_BITS = 12;

    private final String pgShard;

    public Mids(final String pgShard) {
        super(INITIAL_MIDS_CAPACITY, CHUNK_SIZE_BITS);
        this.pgShard = pgShard;
    }

    public String pgShard() {
        return pgShard;
    }

    @Override
    public void handle(final List<PathComponent> path, final Object value)
        throws JsonUnexpectedTokenException
    {
        if (path.size() == 2 + 1
            && "mid".equals(path.get(2).name())
            && path.get(1).name() == null
            && "rows".equals(path.get(0).name()))
        {
            addLong(ValueUtils.asLong(value));
        }
    }
}

