package ru.yandex.search.mail.indexer.pg;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HeadersParser;
import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public class MidsConsumerFactory
    implements HttpAsyncResponseConsumerFactory<Mids>
{
    public static final MidsConsumerFactory INSTANCE =
        new MidsConsumerFactory();
    public static final HttpAsyncResponseConsumerFactory<Mids> OK =
        new StatusCheckAsyncResponseConsumerFactory<Mids>(
            HttpStatusPredicates.OK,
            INSTANCE);

    protected MidsConsumerFactory() {
    }

    @Override
    public MidsConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new MidsConsumer(
            response.getEntity(),
            new Mids(
                new HeadersParser(response)
                    .getString(YandexHeaders.PGSHARD, null)));
    }
}

