package ru.yandex.search.mail.indexer.pg;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class PgIndexerConfigBuilder
    extends AbstractPgIndexerConfigBuilder<PgIndexerConfigBuilder>
{
    public PgIndexerConfigBuilder() {
        super(PgIndexerConfigDefaults.INSTANCE);
    }

    public PgIndexerConfigBuilder(final PgIndexerConfig config) {
        super(config);
    }

    public PgIndexerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, PgIndexerConfigDefaults.INSTANCE);
    }

    public PgIndexerConfigBuilder(
        final IniConfig config,
        final PgIndexerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public PgIndexerConfigBuilder self() {
        return this;
    }

    public ImmutablePgIndexerConfig build() throws ConfigException {
        return new ImmutablePgIndexerConfig(this);
    }
}

