package ru.yandex.search.mail.indexer.pg;

import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;

public class PgIndexerConfigDefaults
    extends HttpProxyConfigDefaults
    implements PgIndexerConfig
{
    public static final PgIndexerConfigDefaults INSTANCE =
        new PgIndexerConfigDefaults();

    private static final int DEFAULT_MIDS_PER_REQUEST = 100;
    private static final int DEFAULT_PRODUCER_BATCH_SIZE = 1; // no batching

    protected PgIndexerConfigDefaults() {
    }

    @Override
    public String name() {
        return "PgIndexer";
    }

    @Override
    public HttpHostConfigDefaults msalConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults producerConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public String serviceName() {
        return null;
    }

    @Override
    public int midsPerRequest() {
        return DEFAULT_MIDS_PER_REQUEST;
    }

    @Override
    public int producerBatchSize() {
        return DEFAULT_PRODUCER_BATCH_SIZE;
    }

    @Override
    public int midsRetrievalRetries() {
        return 1;
    }
}

