package ru.yandex.search.mail.indexer.pg;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;

public class ReindexContext {
    private static final long SHARDS = 65534;

    private final ProxySession session;
    private final long uid;
    private int iteration = 0;

    public ReindexContext(final ProxySession session)
        throws BadRequestException
    {
        this.session = session;
        uid = session.params().getLong("prefix");
    }

    public ProxySession session() {
        return session;
    }

    public long uid() {
        return uid;
    }

    public int iteration() {
        return iteration;
    }

    public void incrementIteration() {
        ++iteration;
    }

    public long shard() {
        return uid % SHARDS;
    }
}

