package ru.yandex.search.msal.pool;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractAddressPgConfigBuilder
    <T extends AbstractAddressPgConfigBuilder<T>>
     extends PoolConfigBuilder
     implements AddressPgConfig
{
    private String url;

    protected AbstractAddressPgConfigBuilder(final AddressPgConfig config) {
        super(config);
        url(config.url());
    }

    protected AbstractAddressPgConfigBuilder(
        final IniConfig config,
        final AddressPgConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.url = config.getString("url", defaults.url());
    }

    @Override()
    public String url() {
        return url;
    }

    public T url(final String value) {
        this.url = value;
        return self();
    }

    protected abstract T self();
}
