package ru.yandex.search.msal.pool;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class AddressPgConfigBuilder
     extends AbstractAddressPgConfigBuilder<AddressPgConfigBuilder>
{
    public AddressPgConfigBuilder() {
        this(AddressPgConfigDefaults.INSTANCE);
    }

    public AddressPgConfigBuilder(final AddressPgConfig config) {
        super(config);
    }

    public AddressPgConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, AddressPgConfigDefaults.INSTANCE);
    }

    public AddressPgConfigBuilder(
        final IniConfig config,
        final AddressPgConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ImmutableAddressPgConfig build() throws ConfigException {
        return new ImmutableAddressPgConfig(
            this);
    }

    @Override
    protected AddressPgConfigBuilder self() {
        return this;
    }
}
