package ru.yandex.search.msal.pool;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.parser.config.ConfigException;

public class ImmutablePoolConfig implements PoolConfig {
    private final String driverName;
    private final String user;
    private final String password;
    private final String pingQuery;
    private final int poolSize;
    private final int timeout;
    private final int prefetchSize;
    private final Map<String, String> properties;

    public ImmutablePoolConfig(final PoolConfig config)
        throws ConfigException
    {
        driverName = config.driverName();
        user = config.user();
        password = config.password();
        pingQuery = config.pingQuery();
        poolSize = config.poolSize();
        timeout = config.timeout();
        prefetchSize = config.prefetchSize();
        if (config.properties().isEmpty()) {
            properties = Collections.emptyMap();
        } else {
            properties = Collections.unmodifiableMap(
                new HashMap<>(config.properties()));
        }

        if (driverName == null) {
            throw new ConfigException("Driver name is not set");
        }
        if (user == null) {
            throw new ConfigException("Database user name is not set");
        }
        if (password == null) {
            throw new ConfigException("Database password is not set");
        }
        if (pingQuery == null) {
            throw new ConfigException("Database ping query is not set");
        }
    }

    @Override
    public String driverName() {
        return driverName;
    }

    @Override
    public String user() {
        return user;
    }

    @Override
    public String password() {
        return password;
    }

    @Override
    public String pingQuery() {
        return pingQuery;
    }

    @Override
    public int poolSize() {
        return poolSize;
    }

    @Override
    public int timeout() {
        return timeout;
    }

    @Override
    public int prefetchSize() {
        return prefetchSize;
    }

    @Override
    public Map<String, String> properties() {
        return properties;
    }
}
