package ru.yandex.search.msal.pool;

import java.sql.Connection;
import java.util.logging.Logger;

public class PoolConnection extends ProxyConnection {
    private volatile DBConnectionPool pool;
    private volatile Logger logger;

    public PoolConnection(
        final Connection conn,
        final DBConnectionPool pool,
        final Logger logger)
    {
        super(conn, pool.prefetchSize());
        this.pool = pool;
        this.logger = logger;
    }

    @Override
    public synchronized void close() {
        if (conn != null && pool != null) {
            pool.freeConnection(conn, logger);
        }
        conn = null;
        pool = null;
        logger = null;
    }
}

