package ru.yandex.search.msal.pool;

import java.sql.SQLException;
import java.sql.Statement;

public class StatementHolder<S extends Statement> implements AutoCloseable {
    private S stmt;

    public StatementHolder(final S stmt) {
        this.stmt = stmt;
    }

    public S get() {
        return stmt;
    }

    public S release() {
        S stmt = this.stmt;
        this.stmt = null;
        return stmt;
    }

    @Override
    public void close() throws SQLException {
        if (stmt != null) {
            stmt.close();
            stmt = null;
        }
    }
}

