package ru.yandex.search.salo;

import java.io.IOException;
import java.math.BigDecimal;

import ru.yandex.dbfields.OracleFields;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonNull;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public abstract class DatabaseEnvelope extends Envelope {
    public static final int DECIMAL_POINT_SHIFT = 6;
    protected final double operationDate;

    protected DatabaseEnvelope(
        final EnvelopesContext context,
        final JsonMap json)
        throws IOException, JsonException
    {
        this(
            context,
            json,
            operationId(json));
    }

    protected DatabaseEnvelope(
        final EnvelopesContext context,
        final JsonMap json,
        final BigDecimal operationId)
        throws IOException, JsonException
    {
        super(context.encode(json), operationId, context);

        JsonObject operationDateObject = json.get(OracleFields.OPERATION_DATE);
        operationDate = operationDateObject.asDouble();
        uri.append("/notify?");
        uri.append(context.dbId());
        uri.append("&operation-id=");
        uri.append(operationId);
        uri.append("&operation-date=");
        uri.append(operationDateObject.asString());
    }

    private static BigDecimal operationId(final JsonMap json)
        throws JsonException
    {
        BigDecimal id =
            new BigDecimal(json.get(OracleFields.OPERATION_ID).asLong());
        JsonObject partObject = json.get(OracleFields.OPERATION_PART);
        if (partObject != JsonNull.INSTANCE) {
            id = id.add(
                new BigDecimal(partObject.asLong())
                    .movePointLeft(DECIMAL_POINT_SHIFT));
        }
        return id;
    }

    @Override
    public boolean optional() {
        return false;
    }

    @Override
    public double operationDate() {
        return operationDate;
    }
}

