package ru.yandex.search.salo;

import java.math.BigDecimal;

import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.ByteArrayBody;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.http.util.request.RequestHandlerMapper;

public abstract class Envelope extends AbstractStringBuilderable {
    private static final int INITIAL_URI_SIZE = 128;

    protected final StringBuilder uri = new StringBuilder(INITIAL_URI_SIZE);
    private final byte[] body;
    private final BigDecimal operationId;
    private final String tokenString;
    private final long tokenVersion;

    protected Envelope(
        final byte[] body,
        final BigDecimal operationId,
        final EnvelopesContext context)
    {
        this.body = body;
        this.operationId = operationId;
        tokenString = context.tokenString();
        tokenVersion = context.tokenVersion();
    }

    public abstract int shard();

    public abstract boolean optional();

    public abstract double operationDate();

    public abstract int midsCount();

    protected abstract void writeAdditionalInfo(StringBuilder sb);

    public int size() {
        return body.length;
    }

    public BigDecimal operationId() {
        return operationId;
    }

    public String tokenString() {
        return tokenString;
    }

    public long tokenVersion() {
        return tokenVersion;
    }

    public StringBuilder copyUri(final int overhead) {
        StringBuilder sb = new StringBuilder(uri.length() + overhead);
        sb.append(uri);
        return sb;
    }

    public ByteArrayEntity createEntity(final ContentType contentType) {
        return new ByteArrayEntity(body, contentType);
    }

    public ByteArrayBody createBody(final ContentType contentType) {
        return new ByteArrayBody(body, contentType, null);
    }

    public String method() {
        return RequestHandlerMapper.POST;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append("{operationId = ");
        sb.append(operationId.toPlainString());
        sb.append(", size = ");
        sb.append(size());
        sb.append(',');
        sb.append(' ');
        writeAdditionalInfo(sb);
        sb.append('}');
    }
}

