package ru.yandex.search.salo;

import java.io.IOException;
import java.util.List;

import ru.yandex.json.dom.ContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.PositionSavingContainerFactory;
import ru.yandex.json.parser.JsonException;

public interface EnvelopeFactory {
    void process(
        EnvelopesContext context,
        JsonMap json,
        List<Envelope> storage)
        throws IOException, JsonException;

    default void process(
        final EnvelopesContext context,
        final JsonList rows,
        final List<Envelope> storage)
        throws IOException, JsonException
    {
        int rowsSize = rows.size();
        for (int i = 0; i < rowsSize; ++i) {
            JsonMap row = rows.get(i).asMap();
            this.process(context, row, storage);
        }
    }

    default String scope() {
        return null;
    }

    default ContainerFactory jsonContainerFactory() {
        return PositionSavingContainerFactory.INSTANCE;
    }
}

