package ru.yandex.search.salo;

import java.io.IOException;

import ru.yandex.function.ByteArrayCopier;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonWriter;

public class EnvelopesContext {
    private final StringBuilder sb = new StringBuilder();
    private final JsonWriter writer =
        new JsonWriter(new StringBuilderWriter(sb));
    private final String tokenString;
    private final long tokenVersion;
    private final Mdb mdb;

    public EnvelopesContext(
        final String tokenString,
        final long tokenVersion,
        final Mdb mdb)
    {
        this.tokenString = tokenString;
        this.tokenVersion = tokenVersion;
        this.mdb = mdb;
    }

    public String tokenString() {
        return tokenString;
    }

    public long tokenVersion() {
        return tokenVersion;
    }

    public String dbId() {
        return mdb.dbId();
    }

    public int midsLimit() {
        return mdb.midsLimit();
    }

    public byte[] encode(final JsonObject json) throws IOException {
        sb.setLength(0);
        writer.reset();
        json.writeValue(writer);
        mdb.encoder().process(sb);
        return mdb.encoder().processWith(ByteArrayCopier.INSTANCE);
    }

    public Mdb mdb() {
        return mdb;
    }
}
