package ru.yandex.search.salo;

import java.util.IdentityHashMap;

import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;

public class MsalResponsesStater implements Stater {
    private static final int EXPECTED_SHARDS = 64;

    private final Iterable<String> data;
    private final String signalName;

    public MsalResponsesStater(
        final Iterable<String> data,
        final String statsPrefix)
    {
        this.data = data;
        signalName = statsPrefix + "-active-msals_ammv";
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        IdentityHashMap<String, String> msals =
            new IdentityHashMap<>(EXPECTED_SHARDS);
        for (String msal: data) {
            msals.put(msal, msal);
        }
        statsConsumer.stat(signalName, msals.size());
    }
}

