package ru.yandex.search.salo;

import java.io.IOException;
import java.util.List;

import ru.yandex.dbfields.OracleFields;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonNull;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;

public class OracleEnvelope extends DatabaseEnvelope {
    public static final EnvelopeFactory FACTORY = new EnvelopeFactory() {
        @Override
        public void process(
            final EnvelopesContext context,
            final JsonMap json,
            final List<Envelope> storage)
            throws IOException, JsonException
        {
            if (json.get(OracleFields.ACTION_TYPE) == JsonNull.INSTANCE) {
                JsonList actions = new JsonList(json.containerFactory());
                actions.add(new JsonString("fresh-reset"));
                json.put(OracleFields.ACTION_TYPE, actions);
            }
            OracleEnvelope envelope = new OracleEnvelope(context, json);
            if (envelope.shard() >= 0) {
                storage.add(envelope);
            }
        }
    };

    private final long suid;
    private final String mid;

    public OracleEnvelope(
        final EnvelopesContext context,
        final JsonMap json)
        throws IOException, JsonException
    {
        super(context, json);
        suid = json.get(OracleFields.UNAME).asLong();
        uri.append("&suid=");
        uri.append(suid);
        String mid = json.get(OracleFields.MID).asStringOrNull();
        if (mid != null) {
            if (mid.isEmpty()) {
                mid = null;
            } else {
                uri.append("&mid=");
                uri.append(mid);
            }
        }
        this.mid = mid;
        for (JsonObject actionType
            : json.get(OracleFields.ACTION_TYPE).asList())
        {
            uri.append("&action-type=");
            uri.append(actionType.asString());
        }
        uri.trimToSize();
    }

    @Override
    public int shard() {
        return (int) (suid % Mdb.SHARDS);
    }

    @Override
    public int midsCount() {
        if (mid == null) {
            return 0;
        } else {
            return 1;
        }
    }

    @Override
    protected void writeAdditionalInfo(final StringBuilder sb) {
        sb.append("suid = ");
        sb.append(suid);
        if (mid != null) {
            sb.append(", mid = ");
            sb.append(mid);
        }
    }
}

